/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.StateTransition;
import edu.colorado.phet.semiconductor.macro.energy.Unexcite;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitLeft;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

class PNForwardClear
extends DefaultStateDiagram {
    private ModelElement pnForward;
    private boolean carryOn;
    private int topLevel;

    public PNForwardClear(EnergySection energySection, ModelElement modelElement) {
        this(energySection, modelElement, true);
    }

    public PNForwardClear(EnergySection energySection, ModelElement modelElement, boolean bl) {
        super(energySection);
        this.pnForward = modelElement;
        this.carryOn = bl;
        this.topLevel = DopantType.P.getNumFilledLevels();
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        boolean bl = this.doClear(d);
        if (bl && this.carryOn) {
            this.pnForward.stepInTime(d);
        }
    }

    public void setTopLevel(int n) {
        this.topLevel = n;
    }

    public boolean doClear(double d) {
        BandParticle bandParticle;
        Object object;
        Object object2;
        EnergyLevel energyLevel;
        int n;
        SemiconductorBandSet semiconductorBandSet = this.getEnergySection().bandSetAt(0);
        SemiconductorBandSet semiconductorBandSet2 = this.getEnergySection().bandSetAt(1);
        Band band = semiconductorBandSet.bandAt(DopantType.P.getDopingBand());
        Band band2 = semiconductorBandSet2.bandAt(DopantType.N.getDopingBand());
        boolean bl = true;
        for (n = 0; n < DopantType.N.getNumFilledLevels() - 1; ++n) {
            energyLevel = band2.energyLevelAt(n);
            if (!this.getEnergySection().isOwned(energyLevel)) {
                object2 = new Entrance(this.getEnergySection(), energyLevel.cellAt(1));
                ((Entrance)object2).stepInTime(d);
                object = new Move(((Entrance)object2).getCell(), this.getEnergySection().getLeftNeighbor(((Entrance)object2).getCell()), this.getSpeed());
                bandParticle = this.getEnergySection().getBandParticle(((Entrance)object2).getCell());
                if (bandParticle != null && bandParticle.isLocatedAtCell()) {
                    ((StateTransition)object).apply(bandParticle, this.getEnergySection());
                }
                bl = false;
                break;
            }
            object2 = this.getEnergySection().getBandParticle(energyLevel.cellAt(0));
            object = this.getEnergySection().getBandParticle(energyLevel.cellAt(1));
            new Unexcite(energyLevel.cellAt(0)).apply((BandParticle)object2);
            new Unexcite(energyLevel.cellAt(1)).apply((BandParticle)object);
        }
        for (n = band.numEnergyLevels() - 1; n >= this.topLevel; --n) {
            energyLevel = band.energyLevelAt(n);
            object2 = energyLevel.cellAt(0);
            object = energyLevel.cellAt(1);
            bandParticle = this.getEnergySection().getBandParticle((EnergyCell)object2);
            BandParticle bandParticle2 = this.getEnergySection().getBandParticle((EnergyCell)object);
            if (bandParticle != null && bandParticle2 != null && n != DopantType.P.getNumFilledLevels()) {
                bl = false;
            }
            if (bandParticle != null) {
                ExitLeft exitLeft = new ExitLeft();
                exitLeft.apply(bandParticle, this.getEnergySection());
                break;
            }
            if (bandParticle2 == null) continue;
            Move move = new Move((EnergyCell)object, (EnergyCell)object2, this.getSpeed());
            move.apply(bandParticle2, this.getEnergySection());
            break;
        }
        return bl;
    }
}

