/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.DepleteLeft;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.NPForwardClear;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ExciteForConduction;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ModelCriteria;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.TypeCriteria;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class NPHandler
implements ModelElement,
ModelCriteria {
    private EnergySection energySection;
    private DefaultStateDiagram npBackBias;
    private ModelElement npForwardBias;
    private ModelElement npForwardClear;
    private NPForwardClear npClearAll;

    public NPHandler(EnergySection energySection) {
        this.energySection = energySection;
        this.npBackBias = new DefaultStateDiagram(energySection);
        ExciteForConduction exciteForConduction = this.npBackBias.exciteN(2, 0);
        this.npBackBias.exitLeft(exciteForConduction.getLeftCell());
        this.npBackBias.addDepleteRight(2);
        this.npBackBias.addFillRight(1);
        this.npBackBias.move(exciteForConduction.getRightCell(), exciteForConduction.getLeftCell(), energySection.getSpeed());
        this.npBackBias.addModelElement(new DepleteLeft(0, 2, energySection));
        this.npBackBias.move(energySection.getRightNeighbor(exciteForConduction.getRightCell()), exciteForConduction.getRightCell(), energySection.getSpeed());
        this.npForwardBias = this.getNPForward();
        this.npForwardClear = new NPForwardClear(energySection, this.npForwardBias);
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(energySection);
        EnergyCell energyCell = energySection.bandSetAt(1).bandAt(1).energyLevelAt(DopantType.P.getNumFilledLevels()).cellAt(1);
        Entrance entrance = defaultStateDiagram.enter(energyCell);
        defaultStateDiagram.moveLeft(entrance.getCell());
        this.npClearAll = new NPForwardClear(energySection, defaultStateDiagram);
        this.npClearAll.setTopLevel(DopantType.P.getNumFilledLevels() + 1);
        Entrance entrance2 = this.npClearAll.enter(energySection.getLowerNeighbor(energyCell));
        Move move = this.npClearAll.move(entrance2.getCell(), energySection.getLeftNeighbor(entrance2.getCell()), energySection.getSpeed());
        this.npClearAll.unexcite(move.getDst().getEnergyLevel());
        EnergyCell energyCell2 = energySection.bandSetAt(1).bandAt(2).energyLevelAt(DopantType.N.getNumFilledLevels()).cellAt(0);
        Move move2 = this.npClearAll.propagateLeft(energyCell2);
        this.npClearAll.exitLeft(move2.getDst());
    }

    private ModelElement getNPForward() {
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(this.energySection);
        ExciteForConduction exciteForConduction = defaultStateDiagram.exciteN(2, 0);
        ExciteForConduction exciteForConduction2 = defaultStateDiagram.exciteP(1, 1);
        defaultStateDiagram.enter(exciteForConduction.getLeftCell());
        defaultStateDiagram.moveRight(exciteForConduction.getLeftCell());
        Move move = defaultStateDiagram.moveRight(exciteForConduction.getRightCell());
        defaultStateDiagram.move(move.getDst(), exciteForConduction2.getLeftCell(), this.energySection.getFallSpeed());
        defaultStateDiagram.move(exciteForConduction2.getLeftCell(), exciteForConduction2.getRightCell(), this.energySection.getSpeed());
        defaultStateDiagram.exitRight(exciteForConduction2.getRightCell());
        return defaultStateDiagram;
    }

    public void stepInTime(double d) {
        if (this.energySection.getVoltage() < 0.0) {
            this.npBackBias.stepInTime(d);
        } else if (this.energySection.getVoltage() > 0.4) {
            this.npForwardClear.stepInTime(d);
        } else {
            this.npClearAll.stepInTime(d);
        }
    }

    public boolean isApplicable(EnergySection energySection) {
        return new TypeCriteria(DopantType.N, DopantType.P).isApplicable(energySection);
    }
}

