/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;

public class FillRight
implements ModelElement {
    int bandSet;
    int band;
    EnergySection energySection;

    public FillRight(int n, int n2, EnergySection energySection) {
        this.bandSet = n;
        this.band = n2;
        this.energySection = energySection;
    }

    public EnergyLevel getActiveLevel() {
        Band band = this.energySection.bandSetAt(this.bandSet).bandAt(this.band);
        for (int i = 0; i < band.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = band.energyLevelAt(i);
            if (this.energySection.isOwned(energyLevel)) continue;
            return energyLevel;
        }
        return null;
    }

    public void stepInTime(double d) {
        EnergyLevel energyLevel = this.getActiveLevel();
        if (energyLevel == null) {
            return;
        }
        EnergyCell energyCell = energyLevel.cellAt(0);
        EnergyCell energyCell2 = energyLevel.cellAt(1);
        Move move = new Move(energyCell2, energyCell, this.energySection.getSpeed());
        BandParticle bandParticle = this.energySection.getBandParticle(energyCell2);
        if (bandParticle != null) {
            boolean bl = move.apply(bandParticle, this.energySection);
        }
        Entrance entrance = new Entrance(this.energySection, energyCell2);
        entrance.stepInTime(d);
    }
}

