/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.semiconductor.SemiconductorApplication;
import edu.colorado.phet.semiconductor.common.EnergySpaceRegion;
import edu.colorado.phet.semiconductor.macro.BucketSection;
import edu.colorado.phet.semiconductor.macro.EntryPoint;
import edu.colorado.phet.semiconductor.macro.circuit.CircuitSection;
import edu.colorado.phet.semiconductor.macro.circuit.ConductionListener;
import edu.colorado.phet.semiconductor.macro.circuit.MacroCircuitGraphic;
import edu.colorado.phet.semiconductor.macro.circuit.battery.Battery;
import edu.colorado.phet.semiconductor.macro.circuit.battery.BatteryListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantChangeListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.ChoiceStateModel;
import edu.colorado.phet.semiconductor.macro.energy.Clear2;
import edu.colorado.phet.semiconductor.macro.energy.Clear3;
import edu.colorado.phet.semiconductor.macro.energy.ConductLeft1;
import edu.colorado.phet.semiconductor.macro.energy.ConductRight1;
import edu.colorado.phet.semiconductor.macro.energy.ConductRight2;
import edu.colorado.phet.semiconductor.macro.energy.ConstantSpeed;
import edu.colorado.phet.semiconductor.macro.energy.DefaultStateDiagram;
import edu.colorado.phet.semiconductor.macro.energy.ElectricFieldSection;
import edu.colorado.phet.semiconductor.macro.energy.ElectricFieldSectionGraphic;
import edu.colorado.phet.semiconductor.macro.energy.NPHandler;
import edu.colorado.phet.semiconductor.macro.energy.PNHandler;
import edu.colorado.phet.semiconductor.macro.energy.PNPHandler;
import edu.colorado.phet.semiconductor.macro.energy.PlusCharge;
import edu.colorado.phet.semiconductor.macro.energy.PlusGraphic;
import edu.colorado.phet.semiconductor.macro.energy.SimpleConductLeft2;
import edu.colorado.phet.semiconductor.macro.energy.SimpleConductLeft3;
import edu.colorado.phet.semiconductor.macro.energy.SimpleConductRight2;
import edu.colorado.phet.semiconductor.macro.energy.SimpleConductRight3;
import edu.colorado.phet.semiconductor.macro.energy.VoltageSplit;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandDescriptor;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticleGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSet;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSetDescriptor;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSetGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyTextGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.JaggedSplitBandGraphic;
import edu.colorado.phet.semiconductor.macro.energy.bands.SemiconductorBandSet;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.DefaultCriteria;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ExciteForConduction;
import edu.colorado.phet.semiconductor.macro.energy.states.MoveToCell;
import edu.colorado.phet.semiconductor.macro.energy.states.Speed;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class EnergySection
implements ModelElement,
BatteryListener,
DopantChangeListener,
Graphic {
    ArrayList conductionListeners = new ArrayList();
    ArrayList bandSets = new ArrayList();
    ArrayList bandSetGraphics = new ArrayList();
    ArrayList particles = new ArrayList();
    ArrayList particleGraphics = new ArrayList();
    ArrayList plusses = new ArrayList();
    ArrayList plusGraphics = new ArrayList();
    ArrayList electricFields = new ArrayList();
    ArrayList electricFieldGraphics = new ArrayList();
    private EnergyTextGraphic energyTextGraphic;
    private ModelViewTransform2D transform;
    private Battery battery;
    private BufferedImage particleImage;
    private BufferedImage plusImage;
    ChoiceStateModel stateModel = new ChoiceStateModel(this);
    private Speed speed;
    private Rectangle2D.Double bounds;
    private BucketSection bucketSection;
    InternalBiasManager biasManager = new InternalBiasManager();
    ArrayList continuousBiasChangeListeners = new ArrayList();

    public EnergySection(ModelViewTransform2D modelViewTransform2D, double d, Battery battery, Speed speed, Rectangle2D.Double double_) throws IOException {
        this.transform = modelViewTransform2D;
        this.battery = battery;
        this.speed = speed;
        this.bounds = double_;
        this.plusImage = SemiconductorApplication.imageLoader.loadImage("semiconductor/images/particle-red-plus.gif");
        this.particleImage = MacroCircuitGraphic.getParticleImage();
        this.setupTwoRegions();
        Vector2D vector2D = new Vector2D(0.65, 1.0);
        this.energyTextGraphic = new EnergyTextGraphic(modelViewTransform2D, vector2D);
        this.bucketSection = new BucketSection(modelViewTransform2D, this, this.particleImage);
        this.generateStateDiagrams();
    }

    public int numParticles() {
        return this.particles.size();
    }

    public BandParticle particleAt(int n) {
        return (BandParticle)this.particles.get(n);
    }

    void clearDoping() {
        this.plusses.clear();
        this.plusGraphics.clear();
        this.particles.clear();
        this.particleGraphics.clear();
    }

    void clearRegions() {
        this.bandSets.clear();
        this.bandSetGraphics.clear();
        this.clearDoping();
        this.electricFields.clear();
        this.electricFieldGraphics.clear();
    }

    double getX() {
        return this.bounds.getX();
    }

    double getY() {
        return this.bounds.getY();
    }

    double getWidth() {
        return this.bounds.getWidth();
    }

    double getHeight() {
        return this.bounds.getHeight();
    }

    void setupOneRegion() {
        double d = this.getWidth() / 2.0;
        double d2 = this.getWidth() / 2.0 - d / 2.0;
        this.newBandSet(new Rectangle2D.Double(this.getX() + d2, this.getY(), d, this.getHeight()), 0);
        this.voltageChanged(this.getBattery());
        this.generateStateDiagrams();
    }

    void setupTwoRegions() {
        double d = this.getWidth() / 3.0;
        double d2 = d / 4.0;
        double d3 = this.getWidth() / 3.0 - d / 2.0;
        double d4 = 2.0 * this.getWidth() / 3.0 - d / 2.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getX() + d3 - d2 / 2.0, this.getY(), d, this.getHeight());
        Rectangle2D.Double double_2 = new Rectangle2D.Double(this.getX() + d4 + d2 / 2.0, this.getY(), d, this.getHeight());
        this.newBandSet(double_, 0);
        this.newBandSet(double_2, 2);
        this.addEField(double_, double_2);
        this.voltageChanged(this.getBattery());
        this.generateStateDiagrams();
    }

    private void generateStateDiagrams() {
        this.stateModel.clear();
        double d = 0.1;
        double d2 = 10.0;
        if (this.numBandSets() == 1) {
            ConductRight1 conductRight1 = new ConductRight1(this, 1, 0, DopantType.P);
            this.stateModel.addModel(new DefaultCriteria(DopantType.P, 0.0, d2), conductRight1);
            ConductLeft1 conductLeft1 = new ConductLeft1(this, 1, 0, DopantType.P);
            this.stateModel.addModel(new DefaultCriteria(DopantType.P, -d2, -d), conductLeft1);
            ConductRight1 conductRight12 = new ConductRight1(this, 2, 0, DopantType.N);
            this.stateModel.addModel(new DefaultCriteria(DopantType.N, 0.0, d2), conductRight12);
            ConductLeft1 conductLeft12 = new ConductLeft1(this, 2, 0, DopantType.N);
            this.stateModel.addModel(new DefaultCriteria(DopantType.N, -d2, -d), conductLeft12);
        }
        if (this.numBandSets() == 2) {
            this.add2StateDiagrams();
        }
        if (this.numBandSets() == 3) {
            this.add3StateDiagrams();
        }
    }

    private void add3StateDiagrams() {
        double d = 0.1;
        double d2 = 10.0;
        DopantType[] dopantTypeArray = new DopantType[]{null, DopantType.P, DopantType.N};
        ArrayList<DopantList> arrayList = new ArrayList<DopantList>();
        for (int i = 0; i < dopantTypeArray.length; ++i) {
            DopantType dopantType = dopantTypeArray[i];
            for (int j = 0; j < dopantTypeArray.length; ++j) {
                DopantType dopantType2 = dopantTypeArray[j];
                for (int k = 0; k < dopantTypeArray.length; ++k) {
                    DopantType dopantType3 = dopantTypeArray[k];
                    arrayList.add(new DopantList(dopantType, dopantType2, dopantType3));
                }
            }
        }
        System.out.println("lists = " + arrayList);
        this.add3StateBothDir(DopantType.P, d2);
        this.add3StateBothDir(DopantType.N, d2);
        PNPHandler pNPHandler = new PNPHandler(this);
        this.stateModel.addModel(pNPHandler, pNPHandler);
    }

    private void add3StateBothDir(DopantType dopantType, double d) {
        DefaultStateDiagram defaultStateDiagram = new SimpleConductRight3(this, dopantType);
        DefaultCriteria defaultCriteria = new DefaultCriteria(dopantType, dopantType, dopantType, 0.0, d);
        Clear3 clear3 = new Clear3(this, ((SimpleConductRight3)defaultStateDiagram).getLeftExcite(), ((SimpleConductRight3)defaultStateDiagram).getMidExcite(), ((SimpleConductRight3)defaultStateDiagram).getRightExcite());
        VoltageSplit voltageSplit = new VoltageSplit(this, clear3, defaultStateDiagram);
        this.stateModel.addModel(defaultCriteria, voltageSplit);
        defaultStateDiagram = new SimpleConductLeft3(this, dopantType);
        defaultCriteria = new DefaultCriteria(dopantType, dopantType, dopantType, -d, 0.0);
        clear3 = new Clear3(this, ((SimpleConductLeft3)defaultStateDiagram).getLeftExcite(), ((SimpleConductLeft3)defaultStateDiagram).getMidExcite(), ((SimpleConductLeft3)defaultStateDiagram).getRightExcite());
        voltageSplit = new VoltageSplit(this, clear3, defaultStateDiagram);
        this.stateModel.addModel(defaultCriteria, voltageSplit);
    }

    private void add2StateDiagrams() {
        this.addSimpleConductRight(DopantType.P);
        this.addSimpleConductRight(DopantType.N);
        this.addS_(DopantType.P);
        this.addS_(DopantType.N);
        this.addSimpleConductLeft(DopantType.P);
        this.addSimpleConductLeft(DopantType.N);
        this.add_S(DopantType.P);
        this.add_S(DopantType.N);
        PNHandler pNHandler = new PNHandler(this);
        this.stateModel.addModel(pNHandler, pNHandler);
        NPHandler nPHandler = new NPHandler(this);
        this.stateModel.addModel(nPHandler, nPHandler);
    }

    private void add_S(DopantType dopantType) {
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(this);
        ExciteForConduction exciteForConduction = defaultStateDiagram.excite(dopantType.getDopingBand(), 0, dopantType.getNumFilledLevels() - 1);
        defaultStateDiagram.move(exciteForConduction.getRightCell(), exciteForConduction.getLeftCell(), this.getSpeed());
        defaultStateDiagram.exitLeft(exciteForConduction.getLeftCell());
        DefaultCriteria defaultCriteria = new DefaultCriteria(dopantType, null, Double.NEGATIVE_INFINITY, 0.0);
        DefaultStateDiagram defaultStateDiagram2 = new DefaultStateDiagram(this);
        EnergyCell energyCell = this.getLowerNeighbor(exciteForConduction.getRightCell());
        EnergyCell energyCell2 = this.getLeftNeighbor(energyCell);
        defaultStateDiagram2.enter(energyCell2);
        defaultStateDiagram2.move(energyCell2, energyCell, this.getSpeed());
        defaultStateDiagram2.move(exciteForConduction.getRightCell(), exciteForConduction.getLeftCell(), this.getSpeed());
        defaultStateDiagram2.exitLeft(exciteForConduction.getLeftCell());
        defaultStateDiagram2.unexcite(energyCell);
        defaultStateDiagram2.unexcite(energyCell2);
        VoltageSplit voltageSplit = new VoltageSplit(this, defaultStateDiagram2, defaultStateDiagram);
        this.stateModel.addModel(defaultCriteria, voltageSplit);
        DefaultStateDiagram defaultStateDiagram3 = new DefaultStateDiagram(this);
        defaultStateDiagram3.enter(energyCell2);
        defaultStateDiagram3.move(energyCell2, energyCell, this.getSpeed());
        defaultStateDiagram3.unexcite(energyCell);
        defaultStateDiagram3.unexcite(energyCell2);
        DefaultCriteria defaultCriteria2 = new DefaultCriteria(null, dopantType, 0.0, Double.POSITIVE_INFINITY);
        this.stateModel.addModel(defaultCriteria2, defaultStateDiagram3);
    }

    private void addS_(DopantType dopantType) {
        DefaultStateDiagram defaultStateDiagram = new DefaultStateDiagram(this);
        ExciteForConduction exciteForConduction = defaultStateDiagram.excite(dopantType.getDopingBand(), 1, dopantType.getNumFilledLevels() - 1);
        defaultStateDiagram.move(exciteForConduction.getLeftCell(), exciteForConduction.getRightCell(), this.getSpeed());
        defaultStateDiagram.exitRight(exciteForConduction.getRightCell());
        DefaultCriteria defaultCriteria = new DefaultCriteria(null, dopantType, 0.0, Double.POSITIVE_INFINITY);
        DefaultStateDiagram defaultStateDiagram2 = new DefaultStateDiagram(this);
        EnergyCell energyCell = this.getLowerNeighbor(exciteForConduction.getRightCell());
        EnergyCell energyCell2 = this.getLeftNeighbor(energyCell);
        defaultStateDiagram2.enter(energyCell);
        defaultStateDiagram2.move(energyCell, energyCell2, this.getSpeed());
        defaultStateDiagram2.move(exciteForConduction.getLeftCell(), exciteForConduction.getRightCell(), this.getSpeed());
        defaultStateDiagram2.exitRight(exciteForConduction.getRightCell());
        defaultStateDiagram2.unexcite(energyCell);
        defaultStateDiagram2.unexcite(energyCell2);
        VoltageSplit voltageSplit = new VoltageSplit(this, defaultStateDiagram2, defaultStateDiagram);
        this.stateModel.addModel(defaultCriteria, voltageSplit);
        DefaultStateDiagram defaultStateDiagram3 = new DefaultStateDiagram(this);
        defaultStateDiagram3.enter(energyCell);
        defaultStateDiagram3.move(energyCell, energyCell2, this.getSpeed());
        defaultStateDiagram3.unexcite(energyCell);
        defaultStateDiagram3.unexcite(energyCell2);
        DefaultCriteria defaultCriteria2 = new DefaultCriteria(null, dopantType, Double.NEGATIVE_INFINITY, 0.0);
        this.stateModel.addModel(defaultCriteria2, defaultStateDiagram3);
    }

    private void addSimpleConductLeft(DopantType dopantType) {
        SimpleConductLeft2 simpleConductLeft2 = new SimpleConductLeft2(this, dopantType);
        Clear2 clear2 = new Clear2(this, simpleConductLeft2.getLeftExcite(), simpleConductLeft2.getRightExcite());
        ConductRight2 conductRight2 = new ConductRight2(this, clear2, simpleConductLeft2);
        DefaultCriteria defaultCriteria = new DefaultCriteria(dopantType, dopantType, Double.NEGATIVE_INFINITY, 0.0);
        this.stateModel.addModel(defaultCriteria, conductRight2);
    }

    private void addSimpleConductRight(DopantType dopantType) {
        SimpleConductRight2 simpleConductRight2 = new SimpleConductRight2(this, dopantType);
        Clear2 clear2 = new Clear2(this, simpleConductRight2.getLeftExcite(), simpleConductRight2.getRightExcite());
        ConductRight2 conductRight2 = new ConductRight2(this, clear2, simpleConductRight2);
        DefaultCriteria defaultCriteria = new DefaultCriteria(dopantType, dopantType, 0.0, Double.POSITIVE_INFINITY);
        this.stateModel.addModel(defaultCriteria, conductRight2);
    }

    public void addEField(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        Vector2D vector2D = EnergySection.getCenter(double_, double_2);
        ElectricFieldSection electricFieldSection = new ElectricFieldSection(vector2D);
        ElectricFieldSectionGraphic electricFieldSectionGraphic = new ElectricFieldSectionGraphic(electricFieldSection, this.transform);
        this.electricFields.add(electricFieldSection);
        this.electricFieldGraphics.add(electricFieldSectionGraphic);
    }

    public static Vector2D getCenter(Rectangle2D.Double double_, Rectangle2D.Double double_2) {
        Rectangle2D.Double double_3 = new Rectangle2D.Double(double_.x, double_.y, double_.width, double_.height);
        double_3.add(double_2);
        Vector2D vector2D = RectangleUtils.getCenter(double_3);
        return vector2D;
    }

    private void newBandSet(Rectangle2D.Double double_, int n) {
        this.newBandSet(double_, false, n);
    }

    private BandSetDescriptor toBandSetDescriptor(Rectangle2D.Double double_) {
        double d = double_.getHeight() / 3.2;
        double_ = new Rectangle2D.Double(double_.getX(), double_.getY() - d / 2.0, double_.getWidth(), double_.getHeight() + d);
        BandSetDescriptor bandSetDescriptor = new BandSetDescriptor();
        int n = 4;
        int n2 = 10;
        double d2 = double_.getHeight() / 8.0;
        double d3 = double_.getHeight() / 40.0;
        double d4 = double_.getHeight() - d2 - d3;
        double d5 = d4 / (double)n;
        BandDescriptor bandDescriptor = new BandDescriptor(n2, new EnergySpaceRegion(double_.getX(), double_.getY(), double_.getWidth(), d5), d3);
        BandDescriptor bandDescriptor2 = new BandDescriptor(n2, new EnergySpaceRegion(double_.getX(), bandDescriptor.getNextEnergyStart(), double_.getWidth(), d5), d2);
        BandDescriptor bandDescriptor3 = new BandDescriptor(n2, new EnergySpaceRegion(double_.getX(), bandDescriptor2.getNextEnergyStart(), double_.getWidth(), d5), d3);
        BandDescriptor bandDescriptor4 = new BandDescriptor(n2, new EnergySpaceRegion(double_.getX(), bandDescriptor3.getNextEnergyStart(), double_.getWidth(), d5), d3);
        bandSetDescriptor.addBandDescriptor(bandDescriptor);
        bandSetDescriptor.addBandDescriptor(bandDescriptor2);
        bandSetDescriptor.addBandDescriptor(bandDescriptor3);
        bandSetDescriptor.addBandDescriptor(bandDescriptor4);
        return bandSetDescriptor;
    }

    private void newBandSet(Rectangle2D.Double double_, boolean bl, int n) {
        BandSetDescriptor bandSetDescriptor = this.toBandSetDescriptor(double_);
        SemiconductorBandSet semiconductorBandSet = new SemiconductorBandSet(bandSetDescriptor, this, n);
        BandSetGraphic bandSetGraphic = null;
        bandSetGraphic = bl ? new JaggedSplitBandGraphic(this, this.transform, semiconductorBandSet, double_) : new BandSetGraphic(this, this.transform, semiconductorBandSet, double_);
        this.bandSets.add(semiconductorBandSet);
        this.bandSetGraphics.add(bandSetGraphic);
        this.initParticles(semiconductorBandSet);
    }

    private void initParticles(SemiconductorBandSet semiconductorBandSet) {
        Band band = semiconductorBandSet.getBottomBand();
        this.fillBand(band);
        this.fillBand(semiconductorBandSet.getValenceBand());
    }

    private void fillBand(Band band) {
        for (int i = 0; i < band.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = band.energyLevelAt(i);
            this.fillLevel(energyLevel);
        }
    }

    public void fillLevel(EnergyLevel energyLevel) {
        for (int i = 0; i < energyLevel.numCells(); ++i) {
            BandParticle bandParticle = new BandParticle(energyLevel.cellAt(i));
            PlusCharge plusCharge = new PlusCharge(energyLevel.cellAt(i));
            this.addPlus(plusCharge);
            this.addParticle(bandParticle);
        }
    }

    private void addPlus(PlusCharge plusCharge) {
        PlusGraphic plusGraphic = new PlusGraphic(plusCharge, this.transform, this.plusImage);
        this.plusses.add(plusCharge);
        this.plusGraphics.add(plusGraphic);
    }

    public void stepInTime(double d) {
        for (int i = 0; i < this.particles.size(); ++i) {
            BandParticle bandParticle = (BandParticle)this.particles.get(i);
            bandParticle.stepInTime(d);
        }
        this.stateModel.stepInTime(d);
        this.recomputeElectricFields();
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        Object object;
        this.energyTextGraphic.paint(graphics2D);
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < this.bandSetGraphics.size(); ++i) {
            BandSetGraphic bandSetGraphic = (BandSetGraphic)this.bandSetGraphics.get(i);
            object = this.transform.createTransformedShape(bandSetGraphic.getViewport());
            rectangle2D = rectangle2D == null ? object.getBounds2D() : rectangle2D.createUnion(object.getBounds2D());
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(rectangle2D);
        for (n = 0; n < this.bandSetGraphics.size(); ++n) {
            object = (BandSetGraphic)this.bandSetGraphics.get(n);
            ((BandSetGraphic)object).paint(graphics2D);
        }
        for (n = 0; n < this.particleGraphics.size(); ++n) {
            object = (BandParticleGraphic)this.particleGraphics.get(n);
            ((BandParticleGraphic)object).paint(graphics2D);
        }
        for (n = 0; n < this.plusGraphics.size(); ++n) {
            object = (Graphic)this.plusGraphics.get(n);
            object.paint(graphics2D);
        }
        for (n = 0; n < this.electricFieldGraphics.size(); ++n) {
            object = (ElectricFieldSectionGraphic)this.electricFieldGraphics.get(n);
            ((ElectricFieldSectionGraphic)object).paint(graphics2D);
        }
        graphics2D.setClip(shape);
        this.bucketSection.paint(graphics2D);
    }

    public void addParticle(BandParticle bandParticle) {
        this.particles.add(bandParticle);
        BandParticleGraphic bandParticleGraphic = new BandParticleGraphic(bandParticle, this.transform, this.particleImage);
        this.particleGraphics.add(bandParticleGraphic);
    }

    public void removeParticle(BandParticle bandParticle) {
        this.particles.remove(bandParticle);
        for (int i = 0; i < this.particleGraphics.size(); ++i) {
            BandParticleGraphic bandParticleGraphic = (BandParticleGraphic)this.particleGraphics.get(i);
            if (bandParticleGraphic.getBandParticle() != bandParticle) continue;
            this.particleGraphics.remove(bandParticleGraphic);
            --i;
        }
    }

    private void removePlus(PlusCharge plusCharge) {
        this.plusses.remove(plusCharge);
        for (int i = 0; i < this.plusGraphics.size(); ++i) {
            PlusGraphic plusGraphic = (PlusGraphic)this.plusGraphics.get(i);
            if (plusGraphic.getPlusCharge() != plusCharge) continue;
            this.plusGraphics.remove(plusGraphic);
            --i;
        }
    }

    public SemiconductorBandSet bandSetAt(int n) {
        return (SemiconductorBandSet)this.bandSets.get(n);
    }

    public int numBandSets() {
        return this.bandSets.size();
    }

    void setDopant(SemiconductorBandSet semiconductorBandSet, DopantType dopantType) {
        semiconductorBandSet.setDopantType(dopantType);
    }

    public void clear(EnergyLevel energyLevel) {
        SimpleObservable simpleObservable;
        int n;
        for (n = 0; n < this.particles.size(); ++n) {
            simpleObservable = (BandParticle)this.particles.get(n);
            if (((BandParticle)simpleObservable).getEnergyLevel() != energyLevel) continue;
            this.removeParticle((BandParticle)simpleObservable);
            --n;
        }
        for (n = 0; n < this.plusses.size(); ++n) {
            simpleObservable = (PlusCharge)this.plusses.get(n);
            if (((PlusCharge)simpleObservable).getEnergyLevel() != energyLevel) continue;
            this.removePlus((PlusCharge)simpleObservable);
            --n;
        }
    }

    public void dopingChanged(CircuitSection circuitSection) {
        this.clearDoping();
        for (int i = 0; i < circuitSection.numDopantSlots() && i < this.numBandSets(); ++i) {
            this.setDopant(this.bandSetAt(i), circuitSection.dopantSlotAt(i).getDopantType());
        }
        if (this.getVoltage() == 0.0) {
            this.biasManager.setupInternalBias();
        }
        this.determineState();
        this.recomputeElectricFields();
        this.generateStateDiagrams();
    }

    private void determineState() {
    }

    private void recomputeElectricFields() {
        for (int i = 0; i < this.electricFields.size(); ++i) {
            ElectricFieldSection electricFieldSection = (ElectricFieldSection)this.electricFields.get(i);
            SemiconductorBandSet semiconductorBandSet = this.bandSetAt(i);
            SemiconductorBandSet semiconductorBandSet2 = this.bandSetAt(i + 1);
            double d = this.getExcessCharge(semiconductorBandSet2) - this.getExcessCharge(semiconductorBandSet);
            double d2 = this.getAmountComplete();
            double d3 = -d / 12.0 * d2;
            electricFieldSection.getInternalField().setStrength(d3);
        }
    }

    private double getAmountComplete() {
        if (this.continuousBiasChangeListeners.size() == 0) {
            return 1.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.continuousBiasChangeListeners.size(); ++i) {
            ContinuousBiasObserver continuousBiasObserver = (ContinuousBiasObserver)this.continuousBiasChangeListeners.get(i);
            double d2 = continuousBiasObserver.getFractionalDistanceToDestination();
            d += d2;
        }
        double d3 = d / (double)this.continuousBiasChangeListeners.size();
        return d3;
    }

    public void voltageChanged(Battery battery) {
        for (int i = 0; i < this.electricFields.size(); ++i) {
            ElectricFieldSection electricFieldSection = (ElectricFieldSection)this.electricFields.get(i);
            electricFieldSection.voltageChanged(battery);
        }
        this.determineState();
    }

    public Battery getBattery() {
        return this.battery;
    }

    public void addConductionListener(ConductionListener conductionListener) {
        this.conductionListeners.add(conductionListener);
    }

    public Speed getSpeed() {
        return this.speed;
    }

    public void setSingleSection() {
        this.clearRegions();
        this.setupOneRegion();
    }

    public void setDoubleSection() {
        this.clearRegions();
        this.setupTwoRegions();
    }

    public EntryPoint[] getSources() {
        return new EntryPoint[0];
    }

    public double getVoltage() {
        return this.battery.getVoltage();
    }

    public SemiconductorBandSet getRightBand() {
        return this.bandSetAt(this.numBandSets() - 1);
    }

    public EnergyCell getNeighbor(EnergyCell energyCell, int n, int n2) {
        int n3 = energyCell.getEnergyLevelAbsoluteIndex();
        int n4 = energyCell.getColumn();
        return this.energyCellAt(n3 + n, n4 + n2);
    }

    public EnergyCell energyCellAt(int n, int n2) {
        int n3 = n2 / 2;
        int n4 = n2 % 2;
        if (n3 < 0 || n3 >= this.numBandSets()) {
            return null;
        }
        SemiconductorBandSet semiconductorBandSet = this.bandSetAt(n3);
        if (n < 0 || n >= this.numRows()) {
            return null;
        }
        if (n4 == 0 || n4 == 1) {
            return semiconductorBandSet.energyCellAt(n, n4);
        }
        return null;
    }

    public EnergyCell getUpperNeighbor(EnergyCell energyCell) {
        return this.getNeighbor(energyCell, 1, 0);
    }

    public EnergyCell getRightNeighbor(EnergyCell energyCell) {
        return this.getNeighbor(energyCell, 0, 1);
    }

    public EnergyCell getLeftNeighbor(EnergyCell energyCell) {
        return this.getNeighbor(energyCell, 0, -1);
    }

    public EnergyLevel getHighestFilledLevel(SemiconductorBandSet semiconductorBandSet) {
        for (int i = 0; i < semiconductorBandSet.numEnergyLevels(); ++i) {
            EnergyLevel energyLevel = semiconductorBandSet.levelAt(i);
            if (this.isFilled(energyLevel)) continue;
            int n = energyLevel.getAbsoluteHeight();
            if (n == -1) {
                return null;
            }
            return semiconductorBandSet.levelAt(n - 1);
        }
        return null;
    }

    private boolean isFilled(EnergyLevel energyLevel) {
        BandParticle bandParticle = this.getBandParticle(energyLevel.cellAt(0));
        BandParticle bandParticle2 = this.getBandParticle(energyLevel.cellAt(1));
        return bandParticle != null && bandParticle2 != null;
    }

    public boolean isClaimed(EnergyCell energyCell) {
        return this.getBandParticle(energyCell) != null;
    }

    public BandParticle getBandParticle(EnergyCell energyCell) {
        for (int i = 0; i < this.particles.size(); ++i) {
            BandParticle bandParticle = (BandParticle)this.particles.get(i);
            if (bandParticle.getEnergyCell() != energyCell) continue;
            return bandParticle;
        }
        return null;
    }

    public Speed getFallSpeed() {
        return new ConstantSpeed(0.7);
    }

    public int getExcessCharge(BandSet bandSet) {
        SimpleObservable simpleObservable;
        int n;
        int n2 = 0;
        for (n = 0; n < this.particles.size(); ++n) {
            simpleObservable = (BandParticle)this.particles.get(n);
            Band band = ((BandParticle)simpleObservable).getBand();
            if (band == null) continue;
            EnergySpaceRegion energySpaceRegion = band.getRegion();
            if (((BandParticle)simpleObservable).getBandSet() != bandSet || band == null || !energySpaceRegion.contains(((BandParticle)simpleObservable).getPosition())) continue;
            ++n2;
        }
        for (n = 0; n < this.plusses.size(); ++n) {
            simpleObservable = (PlusCharge)this.plusses.get(n);
            if (((PlusCharge)simpleObservable).getBandSet() != bandSet) continue;
            --n2;
        }
        return n2;
    }

    public SemiconductorBandSet getLeftBand() {
        return this.bandSetAt(0);
    }

    public double getAverageParticleDX() {
        double d = 0.0;
        for (int i = 0; i < this.particles.size(); ++i) {
            BandParticle bandParticle = (BandParticle)this.particles.get(i);
            ImmutableVector2D immutableVector2D = bandParticle.getDX();
            double d2 = immutableVector2D.getX();
            d += d2;
        }
        return d / (double)this.particles.size();
    }

    public BandSetGraphic bandSetGraphicAt(int n) {
        return (BandSetGraphic)this.bandSetGraphics.get(n);
    }

    private boolean isPNP() {
        return this.isTriodeForTypes(DopantType.P, DopantType.N, DopantType.P);
    }

    private boolean isNPN() {
        return this.isTriodeForTypes(DopantType.N, DopantType.P, DopantType.N);
    }

    public boolean isPN() {
        return this.isDiodeForTypes(DopantType.P, DopantType.N);
    }

    public boolean isNP() {
        return this.isDiodeForTypes(DopantType.N, DopantType.P);
    }

    public boolean isDiodeForTypes(DopantType dopantType, DopantType dopantType2) {
        if (this.numBandSets() == 2) {
            DopantType dopantType3 = this.bandSetAt(0).getDopantType();
            DopantType dopantType4 = this.bandSetAt(1).getDopantType();
            return dopantType3 == dopantType && dopantType4 == dopantType2;
        }
        return false;
    }

    public boolean isTriodeForTypes(DopantType dopantType, DopantType dopantType2, DopantType dopantType3) {
        if (this.numBandSets() == 3) {
            DopantType dopantType4 = this.bandSetAt(0).getDopantType();
            DopantType dopantType5 = this.bandSetAt(1).getDopantType();
            DopantType dopantType6 = this.bandSetAt(2).getDopantType();
            return dopantType4 == dopantType && dopantType5 == dopantType2 && dopantType6 == dopantType3;
        }
        return false;
    }

    private void setupBias(EnergyCell energyCell, int n) {
        EnergyCell energyCell2 = this.getNeighbor(energyCell, 0, n);
        SemiconductorBandSet semiconductorBandSet = energyCell2.getBandSet();
        EnergyLevel energyLevel = this.getHighestFilledLevel(semiconductorBandSet);
        EnergyLevel energyLevel2 = semiconductorBandSet.levelAt(energyLevel.getAbsoluteHeight() + 1);
        EnergyCell energyCell3 = energyLevel2.cellAt(energyCell2.getIndex());
        this.setupBias(energyCell, energyCell3);
    }

    private void setupBias(EnergyCell energyCell, EnergyCell energyCell2) {
        BandParticle bandParticle = this.getBandParticle(energyCell);
        if (bandParticle.isLocatedAtCell() && !this.isClaimed(energyCell2)) {
            ContinuousBiasObserver continuousBiasObserver = new ContinuousBiasObserver(energyCell2, bandParticle);
            this.continuousBiasChangeListeners.add(continuousBiasObserver);
            bandParticle.setState(new MoveToCell(bandParticle, energyCell2, 0.2));
        }
    }

    public int numColumns() {
        return this.numBandSets() * 2;
    }

    public int numRows() {
        return this.bandSetAt(0).numEnergyLevels();
    }

    public int getColumnCharge(int n) {
        int n2;
        if (n == -1) {
            double d = this.getVoltage();
            return (int)d;
        }
        if (n == this.numColumns()) {
            double d = this.getVoltage();
            return -((int)d);
        }
        int n3 = 0;
        Rectangle2D.Double double_ = this.getColumnRect(n);
        for (n2 = 0; n2 < this.numParticles(); ++n2) {
            if (!double_.contains(this.particleAt(n2).getPosition().toPoint2D())) continue;
            ++n3;
        }
        for (n2 = 0; n2 < this.numPlusses(); ++n2) {
            PlusCharge plusCharge = this.plusAt(n2);
            if (!double_.contains(plusCharge.getPosition().toPoint2D())) continue;
            --n3;
        }
        return n3;
    }

    private PlusCharge plusAt(int n) {
        return (PlusCharge)this.plusses.get(n);
    }

    private int numPlusses() {
        return this.plusses.size();
    }

    public Rectangle2D.Double getColumnRect(int n) {
        int n2 = n % 2;
        SemiconductorBandSet semiconductorBandSet = this.bandSetAt(n / 2);
        Rectangle2D.Double double_ = semiconductorBandSet.getBounds();
        if (n2 == 0) {
            Rectangle2D.Double double_2 = new Rectangle2D.Double(double_.x, double_.y, double_.width / 2.0, double_.height);
            return double_2;
        }
        if (n2 == 1) {
            Rectangle2D.Double double_3 = new Rectangle2D.Double(double_.x + double_.width / 2.0, double_.y, double_.width / 2.0, double_.height);
            return double_3;
        }
        throw new RuntimeException("No such case.");
    }

    public EnergyCell getLowerNeighbor(EnergyCell energyCell) {
        int n = energyCell.getIndex();
        int n2 = energyCell.getEnergyLevel().getAbsoluteHeight();
        if (n2 == 0) {
            return null;
        }
        EnergyLevel energyLevel = energyCell.getBandSet().levelAt(n2 - 1);
        if (energyLevel == null) {
            return null;
        }
        return energyLevel.cellAt(n);
    }

    public boolean isOwned(EnergyLevel energyLevel) {
        return this.isOwned(energyLevel.cellAt(0)) && this.isOwned(energyLevel.cellAt(1));
    }

    public boolean isOwned(EnergyCell energyCell) {
        BandParticle bandParticle = this.getBandParticle(energyCell);
        return bandParticle != null && bandParticle.isLocatedAtCell();
    }

    class ContinuousBiasObserver
    implements SimpleObserver {
        EnergyCell dst;
        BandParticle donor;
        private double initDist;

        public ContinuousBiasObserver(EnergyCell energyCell, BandParticle bandParticle) {
            this.dst = energyCell;
            this.donor = bandParticle;
            bandParticle.addObserver(this);
            this.initDist = this.getDistanceToDestination();
        }

        public double getDistanceToDestination() {
            return this.dst.getPosition().getSubtractedInstance(this.donor.getPosition()).getMagnitude();
        }

        public double getFractionalDistanceToDestination() {
            return (this.initDist - this.getDistanceToDestination()) / this.initDist;
        }

        public void update() {
            if (this.getFractionalDistanceToDestination() >= 0.99) {
                EnergySection.this.continuousBiasChangeListeners.remove(this);
                this.donor.removeObserver(this);
            }
            EnergySection.this.recomputeElectricFields();
        }
    }

    class DopantList {
        ArrayList list = new ArrayList();

        public DopantList(DopantType dopantType, DopantType dopantType2, DopantType dopantType3) {
            this.list.add(dopantType);
            this.list.add(dopantType2);
            this.list.add(dopantType3);
        }

        public String toString() {
            return this.list.toString();
        }
    }

    class InternalBiasManager {
        ArrayList biases = new ArrayList();

        public InternalBiasManager() {
            this.addInternalBiasSetup(new OneBandSetup());
            this.addInternalBiasSetup(new NPNSetup());
            this.addInternalBiasSetup(new NPSetup());
            this.addInternalBiasSetup(new PNPSetup());
            this.addInternalBiasSetup(new PNSetup());
        }

        public void addInternalBiasSetup(InternalBiasSetup internalBiasSetup) {
            this.biases.add(internalBiasSetup);
        }

        private void setupInternalBias() {
            EnergySection.this.continuousBiasChangeListeners.clear();
            for (int i = 0; i < this.biases.size(); ++i) {
                InternalBiasSetup internalBiasSetup = (InternalBiasSetup)this.biases.get(i);
                if (!internalBiasSetup.isValid(EnergySection.this)) continue;
                internalBiasSetup.apply(EnergySection.this);
                break;
            }
        }
    }

    static interface InternalBiasSetup {
        public boolean isValid(EnergySection var1);

        public void apply(EnergySection var1);
    }

    class NPNSetup
    implements InternalBiasSetup {
        NPNSetup() {
        }

        public boolean isValid(EnergySection energySection) {
            return energySection.isNPN();
        }

        public void apply(EnergySection energySection) {
            EnergyLevel energyLevel = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(1));
            EnergyLevel energyLevel2 = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(0));
            EnergyCell energyCell = energyLevel.cellAt(0);
            EnergyCell energyCell2 = energyLevel.cellAt(1);
            EnergySection.this.setupBias(energyLevel2.cellAt(0), EnergySection.this.getUpperNeighbor(energyCell));
            EnergySection.this.setupBias(energyLevel2.cellAt(1), EnergySection.this.getUpperNeighbor(EnergySection.this.getUpperNeighbor(energyCell)));
            EnergyLevel energyLevel3 = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(2));
            EnergySection.this.setupBias(energyLevel3.cellAt(0), EnergySection.this.getUpperNeighbor(energyCell2));
            EnergySection.this.setupBias(energyLevel3.cellAt(1), EnergySection.this.getUpperNeighbor(EnergySection.this.getUpperNeighbor(energyCell2)));
        }
    }

    class NPSetup
    implements InternalBiasSetup {
        NPSetup() {
        }

        public boolean isValid(EnergySection energySection) {
            return energySection.isNP();
        }

        public void apply(EnergySection energySection) {
            EnergyLevel energyLevel = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(0));
            EnergyCell energyCell = energyLevel.cellAt(0);
            EnergySection.this.setupBias(energyCell, 2);
            EnergyCell energyCell2 = energyLevel.cellAt(1);
            EnergySection.this.setupBias(energyCell2, 2);
        }
    }

    class OneBandSetup
    implements InternalBiasSetup {
        OneBandSetup() {
        }

        public boolean isValid(EnergySection energySection) {
            return energySection.numBandSets() == 1;
        }

        public void apply(EnergySection energySection) {
        }
    }

    class PNPSetup
    implements InternalBiasSetup {
        PNPSetup() {
        }

        public boolean isValid(EnergySection energySection) {
            return energySection.isPNP();
        }

        public void apply(EnergySection energySection) {
            EnergyLevel energyLevel = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(1));
            EnergySection.this.setupBias(energyLevel.cellAt(0), -1);
            EnergySection.this.setupBias(EnergySection.this.getLowerNeighbor(energyLevel.cellAt(0)), -2);
            EnergySection.this.setupBias(energyLevel.cellAt(1), 1);
            EnergySection.this.setupBias(EnergySection.this.getLowerNeighbor(energyLevel.cellAt(1)), 2);
        }
    }

    class PNSetup
    implements InternalBiasSetup {
        PNSetup() {
        }

        public boolean isValid(EnergySection energySection) {
            return energySection.isPN();
        }

        public void apply(EnergySection energySection) {
            EnergyLevel energyLevel = EnergySection.this.getHighestFilledLevel(EnergySection.this.bandSetAt(1));
            EnergyCell energyCell = energyLevel.cellAt(0);
            EnergySection.this.setupBias(energyCell, -2);
            EnergyCell energyCell2 = energyLevel.cellAt(1);
            EnergySection.this.setupBias(energyCell2, -2);
        }
    }
}

