/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.energy;

import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.DepleteRight;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.FillLeft;
import edu.colorado.phet.semiconductor.macro.energy.FillRight;
import edu.colorado.phet.semiconductor.macro.energy.ParticleAction;
import edu.colorado.phet.semiconductor.macro.energy.ParticleActionApplicator;
import edu.colorado.phet.semiconductor.macro.energy.StateTransitionList;
import edu.colorado.phet.semiconductor.macro.energy.Unexcite;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyCell;
import edu.colorado.phet.semiconductor.macro.energy.bands.EnergyLevel;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.Entrance;
import edu.colorado.phet.semiconductor.macro.energy.statemodels.ExciteForConduction;
import edu.colorado.phet.semiconductor.macro.energy.states.Speed;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitLeftFrom;
import edu.colorado.phet.semiconductor.macro.energy.transitions.ExitRightFrom;
import edu.colorado.phet.semiconductor.macro.energy.transitions.Move;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.CompositeModelElement;

public class DefaultStateDiagram
extends CompositeModelElement {
    private EnergySection energySection;
    private StateTransitionList list;
    private ParticleActionApplicator applicator;

    public DefaultStateDiagram(EnergySection energySection) {
        this.energySection = energySection;
        this.list = new StateTransitionList(energySection);
        this.addModelElement(this.list);
        this.applicator = new ParticleActionApplicator(energySection);
        this.addModelElement(this.applicator);
    }

    public EnergySection getEnergySection() {
        return this.energySection;
    }

    public ExciteForConduction exciteP(int n, int n2) {
        return this.excite(n, n2, DopantType.P.getNumFilledLevels() - 1);
    }

    public ExciteForConduction exciteN(int n, int n2) {
        return this.excite(n, n2, DopantType.N.getNumFilledLevels() - 1);
    }

    protected ExciteForConduction createExcite(int n, int n2, int n3) {
        ExciteForConduction exciteForConduction = new ExciteForConduction(this.energySection, n, n2, n3);
        return exciteForConduction;
    }

    public ExciteForConduction excite(int n, int n2, int n3) {
        ExciteForConduction exciteForConduction = this.createExcite(n, n2, n3);
        this.addModelElement(exciteForConduction);
        return exciteForConduction;
    }

    public Move move(EnergyCell energyCell, EnergyCell energyCell2, Speed speed) {
        Move move = new Move(energyCell, energyCell2, speed);
        this.list.addTransition(move);
        return move;
    }

    public Move moveRight(EnergyCell energyCell) {
        return this.move(energyCell, this.energySection.getRightNeighbor(energyCell), this.energySection.getSpeed());
    }

    public void exitRight(EnergyCell energyCell) {
        ExitRightFrom exitRightFrom = new ExitRightFrom(energyCell);
        this.list.addTransition(exitRightFrom);
    }

    public void exitLeft(EnergyCell energyCell) {
        ExitLeftFrom exitLeftFrom = new ExitLeftFrom(energyCell);
        this.list.addTransition(exitLeftFrom);
    }

    public Entrance enter(EnergyCell energyCell) {
        Entrance entrance = new Entrance(this.energySection, energyCell);
        this.addModelElement(entrance);
        return entrance;
    }

    public void fall(EnergyCell energyCell) {
        this.move(energyCell, this.energySection.getLowerNeighbor(energyCell), this.energySection.getFallSpeed());
    }

    public Speed getSpeed() {
        return this.getEnergySection().getSpeed();
    }

    public void unexcite(EnergyCell energyCell) {
        Unexcite unexcite = new Unexcite(energyCell);
        this.addAction(unexcite);
    }

    public void addAction(ParticleAction particleAction) {
        this.applicator.addParticleAction(particleAction);
    }

    public Move propagateRight(EnergyCell energyCell) {
        EnergyCell energyCell2 = energyCell;
        EnergyCell energyCell3 = this.energySection.getRightNeighbor(energyCell2);
        Move move = null;
        while (energyCell3 != null) {
            move = this.move(energyCell2, energyCell3, this.getSpeed());
            energyCell2 = energyCell3;
            energyCell3 = this.energySection.getRightNeighbor(energyCell3);
        }
        return move;
    }

    public Move propagateLeft(EnergyCell energyCell) {
        EnergyCell energyCell2 = energyCell;
        EnergyCell energyCell3 = this.energySection.getLeftNeighbor(energyCell2);
        Move move = null;
        while (energyCell3 != null) {
            move = this.move(energyCell2, energyCell3, this.getSpeed());
            energyCell2 = energyCell3;
            energyCell3 = this.energySection.getLeftNeighbor(energyCell3);
        }
        return move;
    }

    public void addDepleteRight(int n) {
        DepleteRight depleteRight = new DepleteRight(this.energySection.numBandSets() - 1, n, this.energySection);
        this.addModelElement(depleteRight);
    }

    public void addFillLeft(int n) {
        FillLeft fillLeft = new FillLeft(0, n, this.energySection);
        this.addModelElement(fillLeft);
    }

    public void addFillRight(int n) {
        FillRight fillRight = new FillRight(this.energySection.numBandSets() - 1, n, this.energySection);
        this.addModelElement(fillRight);
    }

    public void unexcite(EnergyLevel energyLevel) {
        this.unexcite(energyLevel.cellAt(0));
        this.unexcite(energyLevel.cellAt(1));
    }

    public Move moveLeft(EnergyCell energyCell) {
        return this.move(energyCell, this.energySection.getLeftNeighbor(energyCell), this.energySection.getSpeed());
    }
}

