/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.doping;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.SemiconductorApplication;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class DopantSlotGraphic
implements Graphic {
    private TexturePaint green;
    private TexturePaint red;
    private Shape shape;
    private TexturePaint texture;
    static final Font font = new PhetFont(1, 18);

    public DopantSlotGraphic(Shape shape, DopantType dopantType) throws IOException {
        this.shape = shape;
        this.green = new TexturePaint(SemiconductorApplication.imageLoader.loadImage("semiconductor/images/particle-green-med.gif"), new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
        this.red = new TexturePaint(SemiconductorApplication.imageLoader.loadImage("semiconductor/images/particle-red-med.gif"), new Rectangle2D.Double(0.0, 0.0, 15.0, 15.0));
    }

    public void setDopantType(DopantType dopantType) {
        this.texture = this.getTexture(dopantType);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.texture == null) {
            return;
        }
        graphics2D.setPaint(this.texture);
        graphics2D.fill(this.shape);
        graphics2D.setFont(font);
    }

    private TexturePaint getTexture(DopantType dopantType) {
        if (dopantType == DopantType.N) {
            return this.green;
        }
        if (dopantType == DopantType.P) {
            return this.red;
        }
        return null;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }
}

