/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.doping;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.semiconductor.macro.doping.DopantSlotGraphic;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.io.IOException;

public class DopantSlot
implements TransformListener {
    DopantType dopant;
    Shape modelShape;
    Shape viewShape;
    ModelViewTransform2D transform;
    private Color defaultColor;
    DopantSlotGraphic graphic;

    public DopantSlot(DopantType dopantType, Shape shape, ModelViewTransform2D modelViewTransform2D, Color color) throws IOException {
        this.dopant = dopantType;
        this.modelShape = shape;
        this.transform = modelViewTransform2D;
        this.defaultColor = color;
        this.graphic = new DopantSlotGraphic(this.viewShape, this.getDopantType());
        modelViewTransform2D.addTransformListener(this);
        this.transformChanged(modelViewTransform2D);
    }

    public void setDopantType(DopantType dopantType) {
        this.dopant = dopantType;
        this.graphic.setDopantType(dopantType);
    }

    public Shape getViewShape() {
        return this.viewShape;
    }

    public DopantType getDopantType() {
        return this.dopant;
    }

    public Vector2D getModelCenter() {
        Vector2D vector2D = RectangleUtils.getCenter(this.modelShape.getBounds2D());
        return vector2D;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(this.defaultColor);
        graphics2D.fill(this.viewShape);
        this.graphic.paint(graphics2D);
    }

    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
        this.viewShape = this.transform.getAffineTransform().createTransformedShape(this.modelShape);
        this.graphic.setShape(this.viewShape);
    }
}

