/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.circuit;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.semiconductor.common.StretchedBufferedImage;
import edu.colorado.phet.semiconductor.macro.circuit.LinearBranch;
import edu.colorado.phet.semiconductor.macro.circuit.MacroCircuit;
import edu.colorado.phet.semiconductor.macro.circuit.Resistor;
import edu.colorado.phet.semiconductor.macro.circuit.Wire;
import edu.colorado.phet.semiconductor.macro.circuit.battery.Battery;
import edu.colorado.phet.semiconductor.macro.circuit.battery.BatteryListener;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;

public class MacroCircuitGraphic
implements BatteryListener,
Graphic {
    public static final Color COPPER = new Color(Integer.parseInt("D98719", 16));
    private MacroCircuit circuit;
    private ModelViewTransform2D transform;
    ArrayList wireGraphics = new ArrayList();
    ShapeGraphic resistorGraphic;
    StretchedBufferedImage battGraphic;
    private BufferedImage batteryImage;
    private static BufferedImage particleImage;
    private static ImageLoader loader;

    public MacroCircuitGraphic(MacroCircuit macroCircuit, ModelViewTransform2D modelViewTransform2D) throws IOException {
        this.circuit = macroCircuit;
        this.transform = modelViewTransform2D;
        this.init();
        macroCircuit.getBattery().addBatteryListener(this);
    }

    void init() throws IOException {
        for (int i = 0; i < this.circuit.numBranches(); ++i) {
            Object object;
            Object object2;
            Object object3;
            final LinearBranch linearBranch = this.circuit.wireAt(i);
            if (linearBranch instanceof Wire) {
                object3 = new Line2D.Double(linearBranch.getStartPosition().toPoint2D(), linearBranch.getEndPosition().toPoint2D());
                object2 = COPPER;
                object = new ShapeGraphic((Shape)object3, (Paint)object2, new BasicStroke(MacroCircuitGraphic.getParticleImage().getWidth() + 4));
                this.wireGraphics.add(object);
                Object object4 = object3;
                this.transform.addTransformListener(new TransformListener((Shape)object4, (ShapeGraphic)object){
                    final /* synthetic */ Shape val$sh1;
                    final /* synthetic */ ShapeGraphic val$sg;
                    {
                        this.val$sh1 = shape;
                        this.val$sg = shapeGraphic;
                    }

                    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                        Shape shape = MacroCircuitGraphic.this.transform.getAffineTransform().createTransformedShape(this.val$sh1);
                        this.val$sg.setShape(shape);
                    }
                });
                continue;
            }
            if (linearBranch instanceof Resistor) {
                object3 = new Line2D.Double(linearBranch.getStartPosition().toPoint2D(), linearBranch.getEndPosition().toPoint2D());
                int n = this.transform.modelToViewY(this.circuit.getResistor().getHeight());
                object = new BasicStroke(n);
                this.resistorGraphic = new ShapeGraphic((Shape)object3, Color.yellow, (Stroke)object);
                this.transform.addTransformListener(new TransformListener((Shape)object3){
                    final /* synthetic */ Shape val$sh;
                    {
                        this.val$sh = shape;
                    }

                    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                        Shape shape = MacroCircuitGraphic.this.transform.getAffineTransform().createTransformedShape(this.val$sh);
                        MacroCircuitGraphic.this.resistorGraphic.setShape(shape);
                    }
                });
                continue;
            }
            if (!(linearBranch instanceof Battery)) continue;
            object3 = this.getBatteryImage();
            this.battGraphic = object2 = new StretchedBufferedImage((BufferedImage)object3, new Rectangle(0, 0, 100, 100));
            this.transform.addTransformListener(new TransformListener((StretchedBufferedImage)object2){
                final /* synthetic */ StretchedBufferedImage val$sbi;
                {
                    this.val$sbi = stretchedBufferedImage;
                }

                public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
                    Vector2D vector2D = linearBranch.getEndPosition();
                    Vector2D vector2D2 = linearBranch.getStartPosition();
                    int n = MacroCircuitGraphic.this.batteryImage.getHeight();
                    int n2 = MacroCircuitGraphic.this.transform.modelToViewX(vector2D.getX());
                    int n3 = MacroCircuitGraphic.this.transform.modelToViewX(vector2D2.getX()) - n2;
                    int n4 = MacroCircuitGraphic.this.transform.modelToViewY(vector2D.getY());
                    Rectangle rectangle = new Rectangle(n2, n4 - n / 2, n3, n);
                    this.val$sbi.setOutputRect(rectangle);
                }
            });
        }
    }

    private BufferedImage getBatteryImage() throws IOException {
        if (this.batteryImage != null) {
            return this.batteryImage;
        }
        loader.setPhetLoader();
        this.batteryImage = ImageLoader.loadBufferedImage("semiconductor/images/AA-battery.gif");
        return this.batteryImage;
    }

    public static BufferedImage getParticleImage() throws IOException {
        if (particleImage != null) {
            return particleImage;
        }
        loader.setPhetLoader();
        particleImage = ImageLoader.loadBufferedImage("semiconductor/images/particle-blue-sml.gif");
        return particleImage;
    }

    public int numWireGraphics() {
        return this.wireGraphics.size();
    }

    public Graphic wireGraphicAt(int n) {
        return (Graphic)this.wireGraphics.get(n);
    }

    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.numWireGraphics(); ++i) {
            this.wireGraphicAt(i).paint(graphics2D);
        }
        this.battGraphic.paint(graphics2D);
        this.resistorGraphic.paint(graphics2D);
    }

    public void voltageChanged(Battery battery) {
        if (battery.getVoltage() < 0.0) {
            this.battGraphic.setFlipX(false);
        } else {
            this.battGraphic.setFlipX(true);
        }
    }

    static {
        loader = new ImageLoader();
    }
}

