/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro.circuit;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.semiconductor.macro.circuit.CompositeLinearBranch;
import edu.colorado.phet.semiconductor.macro.circuit.LinearBranch;
import edu.colorado.phet.semiconductor.macro.circuit.Resistor;
import edu.colorado.phet.semiconductor.macro.circuit.Wire;
import edu.colorado.phet.semiconductor.macro.circuit.battery.Battery;

public class Circuit {
    CompositeLinearBranch circuit = new CompositeLinearBranch();
    Vector2D at;
    private double resistorWidth;

    public Circuit(double d, double d2, double d3) {
        this.resistorWidth = d3;
        this.at = new Vector2D(d, d2);
    }

    public LinearBranch wireAt(int n) {
        return this.circuit.branchAt(n);
    }

    public Wire wireTo(double d, double d2) {
        Vector2D vector2D = new Vector2D(d, d2);
        Wire wire = new Wire(this.at, vector2D);
        this.circuit.addBranch(wire);
        this.at = vector2D;
        return wire;
    }

    public Resistor resistorTo(double d, double d2) {
        Vector2D vector2D = new Vector2D(d, d2);
        Resistor resistor = new Resistor(this.at, vector2D, this.resistorWidth);
        this.circuit.addBranch(resistor);
        this.at = vector2D;
        return resistor;
    }

    public Battery batteryTo(double d, double d2) {
        Vector2D vector2D = new Vector2D(d, d2);
        Battery battery = new Battery(this.at, vector2D);
        this.circuit.addBranch(battery);
        this.at = vector2D;
        return battery;
    }

    public double getLength() {
        return this.circuit.getLength();
    }

    public int numBranches() {
        return this.circuit.numBranches();
    }

    public ImmutableVector2D getPosition(double d) {
        return this.circuit.getPosition(d);
    }

    public boolean contains(double d) {
        return d >= 0.0 && d <= this.getLength();
    }
}

