/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro;

import edu.colorado.phet.semiconductor.SemiconductorApplication;
import edu.colorado.phet.semiconductor.SemiconductorResources;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class DiodeControlPanel
extends JPanel {
    ButtonGroup bg = new ButtonGroup();
    private JPanel pan = new JPanel();
    private JCheckBox gateCheckBox;
    private SemiconductorApplication application;

    public DiodeControlPanel(final SemiconductorApplication semiconductorApplication) {
        this.application = semiconductorApplication;
        this.pan.setLayout(new BoxLayout(this.pan, 1));
        this.addJButton(SemiconductorResources.getString("DiodeControlPanel.OneButton"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                semiconductorApplication.setSingleSection();
            }
        }, false);
        this.addJButton(SemiconductorResources.getString("DiodeControlPanel.TwoButton"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                semiconductorApplication.setDoubleSection();
            }
        }, true);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(SemiconductorResources.getString("DiodeControlPanel.SegmentBorder"));
        this.pan.setBorder(titledBorder);
        this.setBackground(new Color(240, 230, 210));
        this.add(this.pan);
        this.gateCheckBox = new JCheckBox(SemiconductorResources.getString("DiodeControlPanel.GateCheckBox"));
        this.gateCheckBox.setSelected(false);
        this.gateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiodeControlPanel.this.updateGate();
            }
        });
        this.updateGate();
    }

    private void updateGate() {
        this.application.getMagnetGraphic().setVisible(this.gateCheckBox.isSelected());
        if (!this.gateCheckBox.isSelected()) {
            this.application.releaseGate();
        }
    }

    private void addJButton(String string, ActionListener actionListener, boolean bl) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.addActionListener(actionListener);
        jRadioButton.setSelected(bl);
        this.bg.add(jRadioButton);
        this.pan.add(jRadioButton);
    }
}

