/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.macro;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.util.RectangleUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class ColumnDebugGraphic
implements Graphic {
    EnergySection energySection;
    private ModelViewTransform2D trf;
    private boolean visible = false;
    Stroke stroke = new BasicStroke(4.0f, 1, 0);
    Font font = new PhetFont(16);

    public ColumnDebugGraphic(EnergySection energySection, ModelViewTransform2D modelViewTransform2D) {
        this.energySection = energySection;
        this.trf = modelViewTransform2D;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.visible) {
            graphics2D.setColor(Color.blue);
            graphics2D.setFont(this.font);
            graphics2D.setStroke(this.stroke);
            for (int i = 0; i < this.energySection.numColumns(); ++i) {
                Rectangle2D.Double double_ = this.energySection.getColumnRect(i);
                Shape shape = this.trf.createTransformedShape(double_);
                int n = this.energySection.getColumnCharge(i);
                Vector2D vector2D = RectangleUtils.getCenter(double_);
                Point point = this.trf.modelToView(vector2D);
                graphics2D.drawString("ch=" + n, point.x, point.y);
            }
        }
    }
}

