/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.common;

import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class TargetedImageGraphic2
implements Graphic {
    BufferedImage image;
    private Rectangle2D modelBounds;

    public TargetedImageGraphic2(BufferedImage bufferedImage, Rectangle2D rectangle2D) {
        this.image = bufferedImage;
        this.modelBounds = rectangle2D;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.modelBounds.getX(), this.modelBounds.getY());
        double d = this.modelBounds.getWidth() / (double)this.image.getWidth();
        double d2 = this.modelBounds.getHeight() / (double)this.image.getHeight();
        affineTransform.scale(d, d2);
        graphics2D.drawRenderedImage(this.image, affineTransform);
    }
}

