/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor.common;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;

public class Particle
extends SimpleObservable
implements ModelElement {
    ImmutableVector2D position;
    ImmutableVector2D velocity;
    Vector2D acceleration;

    public Particle(double d, double d2) {
        this.position = new Vector2D(d, d2);
        this.velocity = new Vector2D();
        this.acceleration = new Vector2D();
    }

    public Particle(ImmutableVector2D immutableVector2D) {
        this(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public ImmutableVector2D getPosition() {
        return this.position;
    }

    public void stepInTime(double d) {
        ImmutableVector2D immutableVector2D = this.acceleration.getScaledInstance(d);
        this.velocity = this.velocity.getAddedInstance(immutableVector2D);
        ImmutableVector2D immutableVector2D2 = this.velocity.getScaledInstance(d);
        this.position = this.position.getAddedInstance(immutableVector2D2);
        this.notifyObservers();
    }

    public double getX() {
        return this.position.getX();
    }

    public double getY() {
        return this.position.getY();
    }

    public void setPosition(double d, double d2) {
        this.position = new Vector2D(d, d2);
    }

    public void translate(double d, double d2) {
        this.setPosition(this.getX() + d, this.getY() + d2);
    }
}

