/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.semiconductor;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.semiconductor.macro.ColumnDebugGraphic;
import edu.colorado.phet.semiconductor.macro.DiodeControlPanel;
import edu.colorado.phet.semiconductor.macro.GoToMagnet;
import edu.colorado.phet.semiconductor.macro.Magnet;
import edu.colorado.phet.semiconductor.macro.MagnetGraphic;
import edu.colorado.phet.semiconductor.macro.circuit.CircuitSection;
import edu.colorado.phet.semiconductor.macro.circuit.MacroCircuitGraphic;
import edu.colorado.phet.semiconductor.macro.circuit.battery.BatterySpinner;
import edu.colorado.phet.semiconductor.macro.doping.DopantGraphic;
import edu.colorado.phet.semiconductor.macro.doping.DopantPanel;
import edu.colorado.phet.semiconductor.macro.doping.DopantType;
import edu.colorado.phet.semiconductor.macro.energy.EnergySection;
import edu.colorado.phet.semiconductor.macro.energy.ParticleAction;
import edu.colorado.phet.semiconductor.macro.energy.ParticleActionApplicator;
import edu.colorado.phet.semiconductor.macro.energy.bands.Band;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandParticle;
import edu.colorado.phet.semiconductor.macro.energy.bands.BandSetGraphic;
import edu.colorado.phet.semiconductor.macro.energy.states.MoveToCell;
import edu.colorado.phet.semiconductor.macro.energyprobe.Cable;
import edu.colorado.phet.semiconductor.macro.energyprobe.CableGraphic;
import edu.colorado.phet.semiconductor.macro.energyprobe.Lead;
import edu.colorado.phet.semiconductor.macro.energyprobe.LeadGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.ApparatusPanel;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.CompositeInteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.DefaultInteractiveGraphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.Graphic;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.bounds.Boundary;
import edu.colorado.phet.semiconductor.oldphetgraphics.graphics.mousecontrols.Translatable;
import edu.colorado.phet.semiconductor.util.math.DoubleSeries;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.UnsupportedLookAndFeelException;

public class SemiconductorApplication
implements Graphic {
    CircuitSection circuitSection;
    EnergySection energySection;
    ModelViewTransform2D transform;
    private BufferedImage particleImage;
    public static final ImageLoader imageLoader = new ImageLoader();
    private DopantPanel dopantPanel;
    private ArrayList cableGraphics = new ArrayList();
    private Magnet magnet;
    private MagnetGraphic magnetGraphic;
    private ApparatusPanel apparatusPanel;
    private BaseModel bm;
    private DiodeControlPanel dcp;

    public SemiconductorApplication(IClock iClock) throws IOException {
        this.transform = new ModelViewTransform2D(new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0), new Rectangle(0, 0, 1, 1));
        ApparatusPanel apparatusPanel = new ApparatusPanel();
        this.setApparatusPanel(apparatusPanel);
        this.getApparatusPanel().setBackground(new Color(230, 220, 255));
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        int n = 2;
        this.circuitSection = new CircuitSection(this, this.transform, 6.0, 5.0, 3.5, 4.0, n);
        BatterySpinner batterySpinner = this.circuitSection.getBatterySpinner();
        JButton jButton = this.circuitSection.getClearDopantButton();
        this.getApparatusPanel().add(jButton);
        this.getApparatusPanel().add(batterySpinner.getSpinner());
        this.getModel().addModelElement(this.circuitSection);
        this.getApparatusPanel().addGraphic(this.circuitSection);
        this.particleImage = MacroCircuitGraphic.getParticleImage();
        double d = this.transform.viewToModelDifferentialX(this.particleImage.getWidth());
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.1, 0.8, 6.0, 8.5);
        this.energySection = new EnergySection(this.transform, d, this.circuitSection.getCircuit().getBattery(), this.circuitSection, double_);
        this.circuitSection.getCircuit().getBattery().addBatteryListener(this.energySection);
        final DoubleSeries doubleSeries = new DoubleSeries(20);
        ModelElement modelElement = new ModelElement(){

            public void stepInTime(double d) {
                double d2 = SemiconductorApplication.this.energySection.getAverageParticleDX() / d * 2.0;
                doubleSeries.add(d2);
                d2 = doubleSeries.average();
                SemiconductorApplication.this.circuitSection.setConductionAllowed(true);
                SemiconductorApplication.this.circuitSection.setMacroSpeed(d2);
            }
        };
        this.getModel().addModelElement(modelElement);
        this.getModel().addModelElement(this.energySection);
        this.getApparatusPanel().addGraphic(this.energySection);
        this.energySection.addConductionListener(this.circuitSection);
        this.setupCables();
        this.dopantPanel = new DopantPanel(this.getApparatusPanel(), this.transform, imageLoader.loadImage("semiconductor/images/particle-green-med.gif"), imageLoader.loadImage("semiconductor/images/particle-red-med.gif"), new Rectangle2D.Double(8.5, 1.0, 1.0, 3.0));
        this.dopantPanel.addDopantDropListener(this.circuitSection);
        this.circuitSection.addDopantChangeListener(this.energySection);
        this.getApparatusPanel().addGraphic(this.dopantPanel, 2.0);
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                SemiconductorApplication.this.getApparatusPanel().repaint();
            }
        });
        this.getApparatusPanel().addComponentListener(new Relayout());
        this.getApparatusPanel().addGraphic(this);
        ColumnDebugGraphic columnDebugGraphic = new ColumnDebugGraphic(this.energySection, this.transform);
        this.getApparatusPanel().addGraphic(columnDebugGraphic, 10000.0);
        BufferedImage bufferedImage = new ImageLoader().loadImage("semiconductor/images/gate2.gif");
        double d2 = 1.0;
        double d3 = d2 / (double)bufferedImage.getWidth();
        double d4 = (double)bufferedImage.getHeight() * d3;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d2, d4);
        this.magnet = new Magnet(double_2);
        this.magnetGraphic = new MagnetGraphic(this.magnet, this.transform, bufferedImage);
        DefaultInteractiveGraphic defaultInteractiveGraphic = new DefaultInteractiveGraphic(this.magnetGraphic, new Boundary(){

            public boolean contains(int n, int n2) {
                Shape shape = SemiconductorApplication.this.transform.createTransformedShape(SemiconductorApplication.this.magnet.getBounds());
                return shape.contains(n, n2);
            }
        });
        this.addGraphic(defaultInteractiveGraphic, 0);
        defaultInteractiveGraphic.addCursorHandBehavior();
        defaultInteractiveGraphic.addTranslationBehavior(new Translatable(){

            public void translate(double d, double d2) {
                Shape shape;
                Point2D point2D = SemiconductorApplication.this.transform.viewToModelDifferential((int)d, (int)d2);
                Rectangle2D rectangle2D = SemiconductorApplication.this.transform.getModelBounds();
                if (rectangle2D.contains((shape = SemiconductorApplication.this.magnet.getTranslatedShape(point2D.getX(), point2D.getY())).getBounds2D())) {
                    SemiconductorApplication.this.magnet.translate(point2D.getX(), point2D.getY());
                    SemiconductorApplication.this.getApparatusPanel().repaint();
                }
            }
        });
        ModelElement modelElement2 = new ModelElement(){

            public void stepInTime(double d) {
                if (SemiconductorApplication.this.magnetGraphic.isVisible() && SemiconductorApplication.this.energySection.numBandSets() == 3) {
                    Band band = SemiconductorApplication.this.energySection.bandSetAt(1).getTopBand();
                    final Band band2 = SemiconductorApplication.this.energySection.bandSetAt(1).getConductionBand();
                    boolean bl = false;
                    if (band2.getRegion().toRectangle().intersects(SemiconductorApplication.this.magnet.getBounds())) {
                        bl = true;
                    }
                    if (bl) {
                        ParticleAction particleAction = new ParticleAction(){

                            public void apply(BandParticle bandParticle) {
                                if (bandParticle.getBand() == band2 || bandParticle.getBand() == SemiconductorApplication.this.energySection.bandSetAt(1).getValenceBand() && bandParticle.getEnergyLevel().getDistanceFromBottomLevelInBand() >= DopantType.P.getNumFilledLevels() && !bandParticle.isExcited()) {
                                    bandParticle.setState(new GoToMagnet(SemiconductorApplication.this.magnet, bandParticle.getEnergyCell()));
                                }
                            }
                        };
                        ParticleActionApplicator particleActionApplicator = new ParticleActionApplicator(SemiconductorApplication.this.energySection);
                        particleActionApplicator.addParticleAction(particleAction);
                        particleActionApplicator.stepInTime(d);
                        SemiconductorApplication.this.energySection.bandSetAt(1).trickDopantType(DopantType.P);
                    }
                }
            }
        };
        this.addModelElement(modelElement2);
        DiodeControlPanel diodeControlPanel = new DiodeControlPanel(this);
        this.setControlPanel(diodeControlPanel);
    }

    private void setControlPanel(DiodeControlPanel diodeControlPanel) {
        this.dcp = diodeControlPanel;
    }

    private void addModelElement(ModelElement modelElement) {
        this.bm.addModelElement(modelElement);
    }

    private void addGraphic(Graphic graphic, int n) {
    }

    private BaseModel getModel() {
        return this.bm;
    }

    private void setModel(BaseModel baseModel) {
        this.bm = baseModel;
    }

    private void setApparatusPanel(ApparatusPanel apparatusPanel) {
        this.apparatusPanel = apparatusPanel;
    }

    public MagnetGraphic getMagnetGraphic() {
        return this.magnetGraphic;
    }

    public ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    private void setupCables() {
        this.cableGraphics.clear();
        for (int i = 0; i < this.circuitSection.numDopantSlots() && i < this.energySection.numBandSets(); ++i) {
            try {
                this.addCable(this.circuitSection.dopantSlotAt(i).getModelCenter(), i);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.cableGraphics.size(); ++i) {
            Graphic graphic = (Graphic)this.cableGraphics.get(i);
            graphic.paint(graphics2D);
        }
    }

    private void addCable(Vector2D vector2D, int n) throws IOException {
        Lead lead = new Lead(vector2D);
        BandSetGraphic bandSetGraphic = this.energySection.bandSetGraphicAt(n);
        Cable cable = new Cable(lead, bandSetGraphic.getViewportBottomCenter());
        LeadGraphic leadGraphic = new LeadGraphic(this.transform, lead, imageLoader.loadImage("semiconductor/images/probeRed.gif"));
        CableGraphic cableGraphic = new CableGraphic(this.transform, cable, leadGraphic);
        CompositeInteractiveGraphic compositeInteractiveGraphic = new CompositeInteractiveGraphic();
        compositeInteractiveGraphic.addGraphic(leadGraphic);
        compositeInteractiveGraphic.addGraphic(cableGraphic);
        this.cableGraphics.add(compositeInteractiveGraphic);
    }

    private void relayout() {
        int n = this.getApparatusPanel().getWidth();
        int n2 = this.getApparatusPanel().getHeight();
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        this.transform.setViewBounds(rectangle);
    }

    public void removeDopantGraphic(DopantGraphic dopantGraphic) {
        this.dopantPanel.removeDopant(dopantGraphic);
    }

    public void setSingleSection() {
        this.energySection.setSingleSection();
        this.circuitSection.setSingleSection();
        this.setupCables();
        this.relayout();
        this.getApparatusPanel().repaint();
    }

    public void setDoubleSection() {
        this.energySection.setDoubleSection();
        this.circuitSection.setDoubleSection();
        this.setupCables();
        this.relayout();
        this.getApparatusPanel().repaint();
    }

    public void releaseGate() {
        for (int i = 0; i < this.energySection.numParticles(); ++i) {
            BandParticle bandParticle = this.energySection.particleAt(i);
            if (!(bandParticle.getState() instanceof GoToMagnet)) continue;
            GoToMagnet goToMagnet = (GoToMagnet)bandParticle.getState();
            bandParticle.setState(new MoveToCell(bandParticle, goToMagnet.getFrom(), 0.2));
            bandParticle.setExcited(false);
        }
        if (this.energySection.numBandSets() == 3 && this.energySection.bandSetAt(1).getDopantType() == DopantType.P) {
            this.energySection.bandSetAt(1).trickDopantType(DopantType.N);
        }
    }

    private void clockTicked(ClockEvent clockEvent) {
        this.bm.update(clockEvent);
    }

    public static void main(String[] stringArray) throws IOException, UnsupportedLookAndFeelException {
        SemiconductorApplicationConfig semiconductorApplicationConfig = new SemiconductorApplicationConfig(stringArray);
        new PhetApplicationLauncher().launchSim(semiconductorApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new SemiconductorPhetApplication(phetApplicationConfig);
            }
        });
    }

    class Relayout
    extends ComponentAdapter {
        Relayout() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            SemiconductorApplication.this.relayout();
        }

        public void componentResized(ComponentEvent componentEvent) {
            SemiconductorApplication.this.relayout();
        }
    }

    public static class SemiconductorApplicationConfig
    extends PhetApplicationConfig {
        public SemiconductorApplicationConfig(String[] stringArray) {
            super(stringArray, "semiconductor");
            PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();
            phetLookAndFeel.setBackgroundColor(new Color(245, 245, 255));
            this.setLookAndFeel(phetLookAndFeel);
        }
    }

    private static class SemiconductorModule
    extends Module {
        public SemiconductorModule(PhetApplicationConfig phetApplicationConfig) {
            super("name", new ConstantDtClock(30, 1.0));
            try {
                final SemiconductorApplication semiconductorApplication = new SemiconductorApplication(new ConstantDtClock(45, 1.0));
                this.setSimulationPanel(semiconductorApplication.getApparatusPanel());
                this.setControlPanel(semiconductorApplication.dcp);
                this.getClock().addClockListener(new ClockAdapter(){

                    public void clockTicked(ClockEvent clockEvent) {
                        semiconductorApplication.clockTicked(clockEvent);
                        SemiconductorModule.this.getSimulationPanel().repaint();
                    }
                });
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static class SemiconductorPhetApplication
    extends PhetApplication {
        protected SemiconductorPhetApplication(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig);
            this.addModule(new SemiconductorModule(phetApplicationConfig));
        }
    }
}

