/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.view;

import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleGraphicWithTail;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleInfluenceGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class UniverseGraphic
extends PNode {
    private PClip particleLayer;
    private PClip interactionLayer = new PClip();

    public UniverseGraphic(ParticleModel particleModel) {
        this.interactionLayer.setPathTo(new Rectangle2D.Double(0.0, 0.0, particleModel.getBoxWidth(), particleModel.getBoxHeight()));
        this.addChild(this.interactionLayer);
        this.particleLayer = new PClip();
        this.particleLayer.setPathTo(new Rectangle2D.Double(0.0, 0.0, particleModel.getBoxWidth(), particleModel.getBoxHeight()));
        this.addChild(this.particleLayer);
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, particleModel.getBoxWidth(), particleModel.getBoxHeight()));
        pPath.setPaint(Color.white);
        pPath.setStrokePaint(Color.black);
        pPath.setStroke(new BasicStroke(2.0f));
        this.interactionLayer.addChild(pPath);
    }

    public void addInfluenceGraphic(ParticleInfluenceGraphic particleInfluenceGraphic) {
        this.interactionLayer.addChild(particleInfluenceGraphic);
    }

    public void removeInfluenceGraphic(ParticleInfluenceGraphic particleInfluenceGraphic) {
        this.interactionLayer.removeChild(particleInfluenceGraphic);
    }

    public void addParticleGraphic(ParticleGraphicWithTail particleGraphicWithTail) {
        this.particleLayer.addChild(particleGraphicWithTail);
    }

    public void removeParticleGraphic(ParticleGraphicWithTail particleGraphicWithTail) {
        this.particleLayer.removeChild(particleGraphicWithTail);
    }
}

