/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.view;

import edu.colorado.phet.selfdrivenparticlemodel.model.Particle;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class ParticleGraphicWithTail
extends PNode {
    private ParticleGraphic[] particleGraphics;
    private Particle p;
    private ArrayList storedLocations = new ArrayList();
    private int mod;

    public ParticleGraphicWithTail(Particle particle) {
        this(particle, new double[]{8.0, 7.0, 6.0, 5.0, 4.0}, 1);
    }

    public ParticleGraphicWithTail(Particle particle, double[] dArray, int n) {
        int n2;
        this.p = particle;
        this.mod = n;
        this.particleGraphics = new ParticleGraphic[dArray.length];
        Color color = ParticleGraphic.newRandomColor();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d = dArray[n2];
            this.particleGraphics[n2] = new ParticleGraphic(particle, d, color);
            this.addChild(this.particleGraphics[n2]);
        }
        particle.addListener(new Particle.Listener(){

            public void locationChanged() {
                ParticleGraphicWithTail.this.update();
            }
        });
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.update();
        }
    }

    private void update() {
        this.storedLocations.add(new Point2D.Double(this.p.getX(), this.p.getY()));
        while (this.storedLocations.size() > this.particleGraphics.length * this.mod) {
            this.storedLocations.remove(0);
        }
        for (int i = 0; i < this.particleGraphics.length && i < this.storedLocations.size(); i += this.mod) {
            ParticleGraphic particleGraphic = this.particleGraphics[i];
            Point2D point2D = (Point2D)this.storedLocations.get(this.storedLocations.size() - 1 - i);
            particleGraphic.setOffset(point2D);
        }
    }

    public Particle getParticle() {
        return this.p;
    }

    public void setColor(Color color) {
        for (int i = 0; i < this.particleGraphics.length; ++i) {
            ParticleGraphic particleGraphic = this.particleGraphics[i];
            particleGraphic.setColor(color);
        }
    }
}

