/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.view;

import edu.colorado.phet.selfdrivenparticlemodel.model.Particle;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.util.Random;

public class ParticleGraphic
extends PNode {
    private Particle p;
    private PPath child;
    static Random random = new Random();

    public ParticleGraphic(Particle particle, double d, Color color) {
        this.p = particle;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0);
        this.child = new PPath(double_);
        this.child.setStroke(null);
        this.child.setStrokePaint(null);
        this.child.setPaint(color);
        this.addChild(this.child);
        particle.addListener(new Particle.Listener(){

            public void locationChanged() {
                ParticleGraphic.this.update();
            }
        });
        this.update();
    }

    public static Color newRandomColor() {
        float f = random.nextFloat();
        float f2 = random.nextFloat();
        float f3 = (float)((double)((float)((double)random.nextFloat() * 0.8)) + 0.07);
        Color color = Color.getHSBColor(f, f2, f3);
        return color;
    }

    private void update() {
        this.setOffset(this.p.getX(), this.p.getY());
    }

    public void setColor(Color color) {
        this.child.setPaint(color);
    }
}

