/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial.unit1;

import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.PButton;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.Page;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class CollisionSection30
extends Page {
    private PButton againButton;
    private PButton goButton;
    private double dy;

    public CollisionSection30(BasicTutorialCanvas basicTutorialCanvas) {
        super(basicTutorialCanvas);
        this.setText("Particles can see each other if they are within visual range.  I'll indicate visual range with a yellow highlight.  In the nonrandom case, particles choose their direction of motion as the average of all particles within their visual range (including themselves).");
        this.setFinishText("\nYou can run it again if you like.");
        this.dy = this.getParticleModel().getBoxHeight() * 0.2;
    }

    public void init() {
        super.init();
        super.pauseModel();
        super.clearParticles();
        this.getBasePage().getParticleModel().setRandomness(0.0);
        this.getBasePage().addParticle(this.getParticleModel().getBoxWidth() / 2.0, this.getParticleModel().getBoxHeight() * 0.9 - this.dy, -1.5707963267948966, Color.red);
        this.getBasePage().addParticle(this.getParticleModel().getBoxWidth() * 0.1, this.getParticleModel().getBoxHeight() * 0.5 - this.dy, 0.0, Color.blue);
        this.getBasePage().setHalosVisible(true);
        this.againButton = new PButton(this.getBasePage(), "Again!");
        this.againButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollisionSection30.this.runAgain();
            }
        });
        this.goButton = new PButton(this.getBasePage(), "Go!");
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollisionSection30.this.goPressed();
            }
        });
        this.goButton.setOffset(this.getBasePage().getUniverseGraphic().getFullBounds().getMaxX(), this.getBasePage().getUniverseGraphic().getFullBounds().getCenterY());
        this.addChild(this.goButton);
    }

    private void goPressed() {
        this.startModel();
        this.removeChild(this.goButton);
        this.addChild(this.againButton);
        this.againButton.setOffset(this.goButton.getFullBounds().getX(), this.goButton.getFullBounds().getMaxY());
        this.advance();
    }

    private void runAgain() {
        this.pauseModel();
        this.clearParticles();
        this.getBasePage().addParticle(this.getParticleModel().getBoxWidth() / 2.0, this.getParticleModel().getBoxHeight() * 0.9 - this.dy, -1.5707963267948966, Color.red);
        this.getBasePage().addParticle(this.getParticleModel().getBoxWidth() * 0.1, this.getParticleModel().getBoxHeight() * 0.5 - this.dy, 0.0, Color.blue);
        this.getBasePage().addHalos();
        this.startModel();
    }

    public void teardown() {
        super.teardown();
        this.removeChild(this.againButton);
        this.removeChild(this.goButton);
        this.startModel();
    }
}

