/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.dialogs.PhetAboutDialog;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.selfdrivenparticlemodel.SelfDrivenParticleModelApplication;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class TitleScreen
extends PSwingCanvas {
    private PSwing startButton;
    private PImage titleImage;
    private PSwing aboutSwing;

    public TitleScreen(final SelfDrivenParticleModelApplication selfDrivenParticleModelApplication) {
        BufferedImage bufferedImage;
        this.setBackground(Color.lightGray);
        this.setPanEventHandler(null);
        this.setZoomEventHandler(null);
        try {
            bufferedImage = ImageLoader.loadBufferedImage("self-driven-particle-model/images/title-page3.jpg");
            if (SelfDrivenParticleModelApplication.isLowResolution()) {
                bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, selfDrivenParticleModelApplication.getTutorialFrame().getHeight() - 30);
            }
            this.titleImage = new PImage(bufferedImage);
            this.titleImage.setOffset(100.0, 100.0);
            this.addChild(this.titleImage);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedImage = ImageLoader.loadBufferedImage("self-driven-particle-model/images/startbutton.jpg");
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            JButton jButton = new JButton(imageIcon);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    selfDrivenParticleModelApplication.startTutorial();
                }
            });
            this.startButton = new PSwing(jButton);
            this.addChild(this.startButton);
            this.startButton.setOffset((double)this.getWidth() - this.startButton.getWidth() - 5.0, (double)this.getHeight() - this.startButton.getHeight() - 5.0);
            JButton jButton2 = new JButton("About...");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new PhetAboutDialogAdapter((Frame)selfDrivenParticleModelApplication.getTutorialFrame(), new PhetApplicationConfig(new String[0], "self-driven-particle-model")).show();
                }
            });
            this.aboutSwing = new PSwing(jButton2);
            this.addChild(this.aboutSwing);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                TitleScreen.this.relayoutChildren();
            }

            public void componentShown(ComponentEvent componentEvent) {
                TitleScreen.this.relayoutChildren();
            }
        });
        this.relayoutChildren();
    }

    private void relayoutChildren() {
        this.startButton.setOffset((double)this.getWidth() - this.startButton.getWidth() - 5.0, (double)this.getHeight() - this.startButton.getHeight() - 100.0);
        this.aboutSwing.setOffset(this.startButton.getOffset().getX(), this.startButton.getOffset().getY() + this.startButton.getFullBounds().getHeight() + 2.0);
        this.titleImage.setOffset(((double)this.getWidth() - this.titleImage.getWidth()) / 2.0, ((double)this.getHeight() - this.titleImage.getHeight()) / 2.0);
    }

    private void addChild(PNode pNode) {
        this.getLayer().addChild(pNode);
    }

    static class PhetAboutDialogAdapter
    extends PhetAboutDialog {
        public PhetAboutDialogAdapter(Frame frame, ISimInfo iSimInfo) {
            super(frame, iSimInfo);
        }
    }
}

