/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial;

import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.BasicTutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.util.JSAudioPlayer;
import edu.colorado.phet.selfdrivenparticlemodel.view.UniverseGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Point2D;

public abstract class Page {
    private double dy = 0.0;
    private String text = "";
    private boolean noActivity = false;
    private BasicTutorialCanvas basicPage;
    private String finishText;
    private boolean didShowFinishText = false;
    private boolean advanced = false;

    public Page(BasicTutorialCanvas basicTutorialCanvas) {
        this.basicPage = basicTutorialCanvas;
    }

    public void setFinishText(String string) {
        this.finishText = string;
    }

    protected void artificialAdvance() {
        this.advanced = true;
    }

    public void init() {
        this.basicPage.setText(this.text);
        if (this.noActivity) {
            this.basicPage.showNextButton();
            this.artificialAdvance();
        }
        this.basicPage.requestFocus();
    }

    public void setText(String string) {
        this.text = string;
    }

    public BasicTutorialCanvas getBasePage() {
        return this.basicPage;
    }

    public void playHarp() {
        this.getBasePage().playHarp();
    }

    protected void advance() {
        if (!this.advanced) {
            if (this.getFinishText() != null) {
                this.showFinishText();
            }
            this.playHarp();
            this.showNextButton();
            this.advanced = true;
        }
    }

    protected void showFinishText() {
        if (!this.didShowFinishText) {
            this.append(this.getFinishText());
            this.didShowFinishText = true;
        }
    }

    protected void append(String string) {
        this.getBasePage().append(string);
    }

    private String getFinishText() {
        return this.finishText;
    }

    public void teardown() {
    }

    protected void showNextButton() {
        this.getBasePage().showNextButton();
    }

    public void addChild(PNode pNode) {
        if (!this.getBasePage().getLayer().getChildrenReference().contains(pNode)) {
            this.getBasePage().addChild(pNode);
        }
    }

    public void removeChild(PNode pNode) {
        while (this.getBasePage().getLayer().getChildrenReference().contains(pNode)) {
            this.getBasePage().removeChild(pNode);
        }
    }

    public void pauseModel() {
        this.getBasePage().stopModel();
    }

    public void startModel() {
        this.getBasePage().startModel();
    }

    public void clearParticles() {
        this.getBasePage().clearParticles();
    }

    public ParticleModel getParticleModel() {
        return this.getBasePage().getParticleModel();
    }

    public UniverseGraphic getUniverseGraphic() {
        return this.getBasePage().getUniverseGraphic();
    }

    public String getFullText() {
        return this.text + (this.finishText == null ? "" : this.finishText);
    }

    public String getPartialText() {
        return this.text;
    }

    public String getVisibleText() {
        if (this.advanced) {
            return this.getFullText();
        }
        return this.getPartialText();
    }

    public boolean getAdvanced() {
        return this.advanced;
    }

    public void playApplause() {
        JSAudioPlayer.playNoBlock(BasicTutorialCanvas.class.getClassLoader().getResource("self-driven-particle-model/audio/claps.wav"));
    }

    public void relayoutChildren() {
    }

    public Point2D getLocationBeneath(PNode pNode) {
        return new Point2D.Double(pNode.getFullBounds().getX(), pNode.getFullBounds().getMaxY() + this.getDy());
    }

    public double getDy() {
        return this.dy;
    }
}

