/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.tutorial;

import edu.colorado.phet.selfdrivenparticlemodel.SelfDrivenParticleModelApplication;
import edu.colorado.phet.selfdrivenparticlemodel.model.Particle;
import edu.colorado.phet.selfdrivenparticlemodel.model.ParticleModel;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.AbstractUnit;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.PButton;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.Page;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.PageMaker;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialCanvas;
import edu.colorado.phet.selfdrivenparticlemodel.tutorial.TutorialTextArea;
import edu.colorado.phet.selfdrivenparticlemodel.view.IParticleApp;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleGraphic;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleGraphicWithTail;
import edu.colorado.phet.selfdrivenparticlemodel.view.ParticleInfluenceGraphic;
import edu.colorado.phet.selfdrivenparticlemodel.view.UniverseGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JComponent;

public class BasicTutorialCanvas
extends TutorialCanvas
implements IParticleApp {
    private UniverseGraphic universeGraphic;
    private ParticleModel particleModel;
    private TutorialTextArea textArea;
    private PButton nextSwing;
    private PActivity modelActivity;
    private ArrayList particleGraphics = new ArrayList();
    private ArrayList influenceGraphics = new ArrayList();
    private double modelDT = 1.0;
    private PageMaker[] pageMakers;
    private ArrayList pages = new ArrayList();
    private int advancedToPageIndex = 0;
    private boolean halosVisible;
    private PButton prevSwing;
    private boolean showedPrevButton = false;
    private int viewingPageIndex = 0;
    private SelfDrivenParticleModelApplication tutorialApplication;
    private MyPSwing textAreaPSwing;
    static final Random random = new Random();

    public BasicTutorialCanvas(SelfDrivenParticleModelApplication selfDrivenParticleModelApplication, AbstractUnit abstractUnit) {
        this.tutorialApplication = selfDrivenParticleModelApplication;
        abstractUnit.setBasePage(this);
        this.particleModel = new ParticleModel(550.0, 550.0);
        this.particleModel.setRandomness(0.0);
        this.universeGraphic = new UniverseGraphic(this.particleModel);
        if (SelfDrivenParticleModelApplication.isLowResolution()) {
            this.universeGraphic.scale(0.82);
        }
        this.textArea = new TutorialTextArea();
        this.setLayout(null);
        this.textAreaPSwing = new MyPSwing(this.textArea);
        this.addChild(this.textAreaPSwing);
        this.nextSwing = new PButton(this, "Next");
        this.nextSwing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTutorialCanvas.this.removeChild(BasicTutorialCanvas.this.nextSwing);
                BasicTutorialCanvas.this.nextSection();
            }
        });
        this.prevSwing = new PButton(this, "Previous");
        this.prevSwing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTutorialCanvas.this.previousSection();
            }
        });
        this.relayoutChildren();
        this.modelActivity = new PActivity(-1L, 30L){

            protected void activityStep(long l) {
                super.activityStep(l);
                BasicTutorialCanvas.this.particleModel.step(BasicTutorialCanvas.this.modelDT);
            }
        };
        this.pageMakers = abstractUnit.getPageMakers();
        this.advancedToPageIndex = 0;
        Page page = this.pageMakers[this.advancedToPageIndex].createPage();
        this.pages.add(page);
        this.addKeyListener(selfDrivenParticleModelApplication.getKeyHandler());
        this.getKeyListeners();
        this.relayoutChildren();
    }

    public void setText(String string) {
        this.textArea.setText(string);
        this.relayoutChildren();
    }

    public void createUniverse() {
        this.addChild(this.universeGraphic);
        this.topLeft(this.universeGraphic);
        this.relayoutChildren();
    }

    public UniverseGraphic getUniverseGraphic() {
        return this.universeGraphic;
    }

    public void topLeft(PNode pNode) {
        int n = 2;
        pNode.setOffset(n, this.textAreaPSwing.getFullBounds().getMaxY() + (double)n);
    }

    public void append(String string) {
        this.textArea.setText(this.textArea.getText() + string);
        this.relayoutChildren();
    }

    public void clearParticles() {
        while (this.getParticleModel().numParticles() > 0) {
            this.removeParticle(this.getParticleModel().lastParticle());
        }
    }

    public ParticleModel getParticleModel() {
        return this.particleModel;
    }

    public void setNumberParticles(int n) {
        boolean bl = false;
        while (n < this.particleModel.numParticles()) {
            this.removeParticle(this.particleModel.lastParticle());
            bl = true;
        }
        while (n > this.particleModel.numParticles()) {
            Color color = ParticleGraphic.newRandomColor();
            this.addParticle(random.nextDouble() * this.getParticleModel().getBoxWidth(), random.nextDouble() * this.particleModel.getBoxHeight(), random.nextDouble() * 2.0 * Math.PI, color);
            bl = false;
        }
    }

    private void removeParticle(Particle particle) {
        PNode pNode;
        int n;
        for (n = 0; n < this.particleGraphics.size(); ++n) {
            pNode = (ParticleGraphicWithTail)this.particleGraphics.get(n);
            if (((ParticleGraphicWithTail)pNode).getParticle() != particle) continue;
            this.getUniverseGraphic().removeParticleGraphic((ParticleGraphicWithTail)pNode);
            this.particleGraphics.remove(pNode);
            --n;
        }
        for (n = 0; n < this.influenceGraphics.size(); ++n) {
            pNode = (ParticleInfluenceGraphic)this.influenceGraphics.get(n);
            if (((ParticleInfluenceGraphic)pNode).getParticle() != particle) continue;
            this.getUniverseGraphic().removeInfluenceGraphic((ParticleInfluenceGraphic)pNode);
            this.influenceGraphics.remove(pNode);
            --n;
        }
        this.getParticleModel().removeParticle(particle);
    }

    public void addHalos() {
        for (int i = 0; i < this.particleGraphics.size(); ++i) {
            ParticleGraphicWithTail particleGraphicWithTail = (ParticleGraphicWithTail)this.particleGraphics.get(i);
            if (this.isHaloShowing(particleGraphicWithTail.getParticle())) continue;
            ParticleInfluenceGraphic particleInfluenceGraphic = new ParticleInfluenceGraphic(this.getParticleModel(), particleGraphicWithTail.getParticle());
            this.universeGraphic.addInfluenceGraphic(particleInfluenceGraphic);
            this.influenceGraphics.add(particleInfluenceGraphic);
        }
    }

    private boolean isHaloShowing(Particle particle) {
        for (int i = 0; i < this.influenceGraphics.size(); ++i) {
            ParticleInfluenceGraphic particleInfluenceGraphic = (ParticleInfluenceGraphic)this.influenceGraphics.get(i);
            if (particleInfluenceGraphic.getParticle() != particle) continue;
            return true;
        }
        return false;
    }

    public Point2D getNextButtonLocation() {
        return new Point2D.Double(this.textAreaPSwing.getFullBounds().getWidth() - this.nextSwing.getFullBounds().getWidth() - 5.0, this.textAreaPSwing.getFullBounds().getHeight() + 5.0);
    }

    public void showNextButton() {
        if (!this.getLayer().getChildrenReference().contains(this.nextSwing)) {
            this.addChild(this.nextSwing);
            this.nextSwing.setOffset(this.getNextButtonLocation());
        }
        this.relayoutChildren();
    }

    public void hideNextButton() {
        while (this.getLayer().getChildrenReference().contains(this.nextSwing)) {
            this.removeChild(this.nextSwing);
        }
        this.relayoutChildren();
    }

    private void previousSection() {
        if (this.viewingPageIndex == 0 && this.tutorialApplication.isFirstUnit()) {
            return;
        }
        if (this.viewingPageIndex == 0) {
            this.sectionAt(this.viewingPageIndex).teardown();
            this.tutorialApplication.previousUnit();
            return;
        }
        this.sectionAt(this.viewingPageIndex).teardown();
        --this.viewingPageIndex;
        this.sectionAt(this.viewingPageIndex).init();
        this.synchronizeFullText();
        this.showNextButton();
        this.relayoutChildren();
    }

    private void synchronizeFullText() {
        String string = this.pageMakers[this.viewingPageIndex].createPage().getFullText();
        this.textArea.setText(string);
        this.showNextButton();
    }

    Page sectionAt(int n) {
        return (Page)this.pages.get(n);
    }

    private void synchronizeLastPage() {
        String string = this.sectionAt(this.viewingPageIndex).getVisibleText();
        this.textArea.setText(string);
        if (this.sectionAt(this.viewingPageIndex).getAdvanced()) {
            this.showNextButton();
        }
    }

    private void nextSection() {
        if (this.viewingPageIndex < this.advancedToPageIndex) {
            this.sectionAt(this.viewingPageIndex).teardown();
            ++this.viewingPageIndex;
            this.sectionAt(this.viewingPageIndex).init();
            if (this.viewingPageIndex == this.advancedToPageIndex) {
                this.synchronizeLastPage();
            } else {
                this.synchronizeFullText();
            }
        } else if (this.advancedToPageIndex + 1 < this.pageMakers.length) {
            this.sectionAt(this.viewingPageIndex).teardown();
            ++this.advancedToPageIndex;
            ++this.viewingPageIndex;
            Page page = this.pageMakers[this.advancedToPageIndex].createPage();
            this.pages.add(page);
            this.sectionAt(this.viewingPageIndex).init();
        }
        if (!this.showedPrevButton) {
            this.showedPrevButton = true;
            this.showPrevButton();
        }
    }

    private void showPrevButton() {
        if (!this.getLayer().getChildrenReference().contains(this.prevSwing)) {
            this.addChild(this.prevSwing);
            this.relayoutChildren();
        }
    }

    public void addParticle(double d, double d2, double d3, Color color) {
        Particle particle = new Particle(d, d2, d3);
        ParticleGraphicWithTail particleGraphicWithTail = new ParticleGraphicWithTail(particle);
        particleGraphicWithTail.setColor(color);
        this.particleModel.addParticle(particle);
        particle.setLocation(d, d2);
        this.universeGraphic.addParticleGraphic(particleGraphicWithTail);
        this.particleGraphics.add(particleGraphicWithTail);
        if (this.halosVisible) {
            this.addHalos();
        }
    }

    public void startModel() {
        this.getRoot().addActivity(this.modelActivity);
    }

    public void stopModel() {
        this.getRoot().getActivityScheduler().removeActivity(this.modelActivity);
    }

    public void start(SelfDrivenParticleModelApplication selfDrivenParticleModelApplication) {
        super.start(selfDrivenParticleModelApplication);
        this.sectionAt(this.viewingPageIndex).init();
    }

    protected void relayoutChildren() {
        super.relayoutChildren();
        if (this.textArea != null) {
            int n = 150;
            this.textArea.setBounds(0, 0, this.getWidth(), n);
            this.textAreaPSwing.doReshape();
        }
        this.testTopLeft(this.universeGraphic);
        this.nextSwing.setOffset(this.getNextButtonLocation());
        this.prevSwing.setOffset(2.0 + this.universeGraphic.getFullBounds().getMaxX(), this.nextSwing.getFullBounds().getY());
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().relayoutChildren();
        }
    }

    private Page getCurrentPage() {
        if (this.viewingPageIndex >= 0 && this.viewingPageIndex < this.pages.size()) {
            return this.sectionAt(this.viewingPageIndex);
        }
        return null;
    }

    private void testTopLeft(PNode pNode) {
        if (pNode != null) {
            this.topLeft(pNode);
        }
    }

    public void setHalosVisible(boolean bl) {
        this.halosVisible = bl;
        if (bl) {
            this.addHalos();
        } else {
            this.removeHalos();
        }
    }

    private void removeHalos() {
        for (int i = 0; i < this.influenceGraphics.size(); ++i) {
            ParticleInfluenceGraphic particleInfluenceGraphic = (ParticleInfluenceGraphic)this.influenceGraphics.get(i);
            this.influenceGraphics.remove(particleInfluenceGraphic);
            this.getUniverseGraphic().removeInfluenceGraphic(particleInfluenceGraphic);
            --i;
        }
    }

    public boolean isHalosVisible() {
        return this.halosVisible;
    }

    public PButton getPreviousButton() {
        return this.prevSwing;
    }

    public SelfDrivenParticleModelApplication getTutorialApplication() {
        return this.tutorialApplication;
    }

    public void moveRight() {
        this.nextSection();
    }

    public void moveLeft() {
        this.previousSection();
    }

    static class MyPSwing
    extends PSwing {
        public MyPSwing(JComponent jComponent) {
            super(jComponent);
        }

        public void doReshape() {
            this.getComponent().setBounds(0, 0, this.getComponent().getPreferredSize().width, this.getComponent().getPreferredSize().height);
            double d = Math.max(this.getComponent().getPreferredSize().height, 150);
            this.setBounds(0.0, 0.0, this.getComponent().getPreferredSize().width, d);
        }

        public void updateBounds() {
        }
    }
}

