/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.selfdrivenparticlemodel.model;

import java.util.ArrayList;

public class Particle {
    private double x;
    private double y;
    private double angle;
    private ArrayList listeners = new ArrayList();

    public Particle(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.angle = d3;
    }

    public void translate(double d, double d2) {
        this.setLocation(this.x + d, this.y + d2);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setLocation(double d, double d2) {
        if (this.x != d || this.y != d2) {
            this.x = d;
            this.y = d2;
            this.notifyLocationChanged();
        }
    }

    private void notifyLocationChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.locationChanged();
        }
    }

    public double distance(Particle particle) {
        double d = this.x - particle.x;
        double d2 = this.y - particle.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public void setAngle(double d) {
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    public static interface Listener {
        public void locationChanged();
    }
}

