/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.view;

import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.BufferedPNode;
import edu.colorado.phet.rutherfordscattering.RSResources;
import edu.colorado.phet.rutherfordscattering.model.PlumPuddingAtom;
import edu.colorado.phet.rutherfordscattering.view.ElectronNode;
import edu.colorado.phet.rutherfordscattering.view.RSModelViewTransform;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.util.Random;

public class PlumPuddingAtomNode
extends BufferedPNode {
    public PlumPuddingAtomNode(PhetPCanvas phetPCanvas, PlumPuddingAtom plumPuddingAtom) {
        super(phetPCanvas, PlumPuddingAtomNode.createManagedNode(plumPuddingAtom));
        this.setPickable(false);
        this.setChildrenPickable(false);
        Point2D point2D = plumPuddingAtom.getPositionRef();
        Point2D point2D2 = RSModelViewTransform.transform(point2D);
        this.setOffset(point2D2.getX() - this.getFullBounds().getWidth() / 2.0, point2D2.getY() - this.getFullBounds().getHeight() / 2.0);
    }

    private static PNode createManagedNode(PlumPuddingAtom plumPuddingAtom) {
        PNode pNode = new PNode();
        Image image = RSResources.getImage("plumPudding.png");
        PImage pImage = new PImage(image);
        double d = Math.max(pImage.getWidth(), pImage.getHeight());
        double d2 = 2.0 * RSModelViewTransform.transform(plumPuddingAtom.getRadius());
        double d3 = d2 / d;
        pImage.scale(d3);
        pImage.setOffset(-pImage.getFullBounds().getWidth() / 2.0, -pImage.getFullBounds().getHeight() / 2.0);
        pNode.addChild(pImage);
        double d4 = 0.85 * pImage.getFullBounds().getWidth();
        double d5 = 0.85 * pImage.getFullBounds().getHeight();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d4 > d5) {
            d6 = d4 / 2.0;
            d7 = d5 / 2.0;
            d8 = 0.0;
        } else {
            d6 = d5 / 2.0;
            d7 = d4 / 2.0;
            d8 = Math.toRadians(90.0);
        }
        assert (d6 >= d7);
        int n = plumPuddingAtom.getNumberOfElectrons();
        double d9 = Math.toRadians(360.0) / (double)n;
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            double d10 = d8 + (double)i * d9;
            double d11 = d6 * Math.cos(d10);
            double d12 = d7 * Math.sin(d10);
            double d13 = Math.sqrt(d11 * d11 + d12 * d12);
            double d14 = d13 * Math.sqrt(random.nextDouble());
            double d15 = d14 * Math.cos(d10);
            double d16 = d14 * Math.sin(d10);
            ElectronNode electronNode = new ElectronNode();
            electronNode.setOffset(d15, d16);
            pNode.addChild(electronNode);
        }
        PImage pImage2 = new PImage(pNode.toImage()){

            protected void paint(PPaintContext pPaintContext) {
                super.paint(pPaintContext);
            }
        };
        return pImage2;
    }
}

