/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.view;

import edu.colorado.phet.rutherfordscattering.RSConstants;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class BoxOfAtomsNode
extends PNode {
    private static final Paint BOX_FRONT_PAINT = new Color(106, 112, 49);
    private static final Color TOP_COLOR_FRONT = Color.GRAY;
    private static final Color TOP_COLOR_BACK = Color.DARK_GRAY;
    private static final Stroke STROKE = new BasicStroke(1.0f);
    private static final Color STROKE_COLOR = Color.BLACK;
    public static final Color TINY_BOX_FILL_COLOR = RSConstants.ANIMATION_BOX_COLOR;
    public static final Color TINY_BOX_STROKE_COLOR = RSConstants.ANIMATION_BOX_STROKE_COLOR;
    public static final Stroke TINY_BOX_STROKE = new BasicStroke(2.0f);
    private PPath _tinyBoxNode;

    public BoxOfAtomsNode(Dimension dimension, Dimension dimension2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        PNode pNode = new PNode();
        float f = dimension.width;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.15f * f, 0.0f);
        generalPath.lineTo(0.85f * f, 0.0f);
        generalPath.lineTo(f, 10.0f);
        generalPath.lineTo(0.0f, 10.0f);
        generalPath.closePath();
        PPath pPath = new PPath();
        pPath.setPathTo(generalPath);
        pPath.setPaint(new GradientPaint(0.0f, 0.0f, TOP_COLOR_BACK, 0.0f, 10.0f, TOP_COLOR_FRONT));
        pPath.setStroke(STROKE);
        pPath.setStrokePaint(STROKE_COLOR);
        PPath pPath2 = new PPath(new Rectangle2D.Double(0.0, 10.0, dimension.width, dimension.height));
        pPath2.setPaint(BOX_FRONT_PAINT);
        pPath2.setStroke(STROKE);
        pPath2.setStrokePaint(STROKE_COLOR);
        pNode.addChild(pPath2);
        pNode.addChild(pPath);
        pNode.setOffset(0.0, 0.0);
        this.addChild(pNode);
        this._tinyBoxNode = new PPath(new Rectangle2D.Double(0.0, 0.0, dimension2.width, dimension2.height));
        this._tinyBoxNode.setPaint(TINY_BOX_FILL_COLOR);
        this._tinyBoxNode.setStrokePaint(TINY_BOX_STROKE_COLOR);
        this._tinyBoxNode.setStroke(TINY_BOX_STROKE);
        double d = pNode.getFullBounds().getX() + 0.6 * pNode.getFullBounds().getWidth();
        double d2 = pNode.getFullBounds().getY() + 0.5 * pNode.getFullBounds().getHeight();
        this._tinyBoxNode.setOffset(d, d2);
        this.addChild(this._tinyBoxNode);
    }

    public Rectangle2D getTinyBoxGlobalFullBounds() {
        return this._tinyBoxNode.getGlobalFullBounds();
    }
}

