/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.model;

import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.rutherfordscattering.model.AbstractAtom;
import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import edu.colorado.phet.rutherfordscattering.model.RutherfordScattering;
import java.awt.Dimension;
import java.awt.geom.Point2D;

public class RutherfordAtom
extends AbstractAtom {
    private final double _angularSpeed;
    private final int _defaultNumberOfProtons;
    private final int _defaultNumberOfNeutrons;
    private int _numberOfProtons;
    private final int _minNumberOfProtons;
    private final int _maxNumberOfProtons;
    private int _numberOfNeutrons;
    private final int _minNumberOfNeutrons;
    private final int _maxNumberOfNeutrons;
    private final Dimension _boxSize;
    private final double _electronOrbitRadius;
    private double _electronAngle;
    private Point2D _electronOffset;

    public RutherfordAtom(Point2D point2D, double d, double d2, IntegerRange integerRange, IntegerRange integerRange2, Dimension dimension) {
        super(point2D, d);
        assert (dimension.getWidth() == dimension.getHeight());
        this._angularSpeed = d2;
        this._defaultNumberOfProtons = this._numberOfProtons = integerRange.getDefault();
        this._minNumberOfProtons = integerRange.getMin();
        this._maxNumberOfProtons = integerRange.getMax();
        this._defaultNumberOfNeutrons = this._numberOfNeutrons = integerRange2.getDefault();
        this._minNumberOfNeutrons = integerRange2.getMin();
        this._maxNumberOfNeutrons = integerRange2.getMax();
        this._boxSize = new Dimension(dimension);
        double d3 = dimension.getWidth() * Math.sqrt(2.0);
        this._electronOrbitRadius = 0.9 * d3 / 2.0;
        this._electronAngle = 0.0;
        double d4 = this._electronOrbitRadius * Math.sin(this._electronAngle);
        double d5 = this._electronOrbitRadius * Math.cos(this._electronAngle);
        this._electronOffset = new Point2D.Double(d4, d5);
    }

    public int getDefaultNumberOfProtons() {
        return this._defaultNumberOfProtons;
    }

    public void setNumberOfProtons(int n) {
        if (n < this._minNumberOfProtons || n > this._maxNumberOfProtons) {
            throw new IllegalArgumentException("numberOfProtons is out of range: " + n);
        }
        if (n != this._numberOfProtons) {
            this._numberOfProtons = n;
            this.notifyObservers("numberOfProtons");
        }
    }

    public int getNumberOfProtons() {
        return this._numberOfProtons;
    }

    public int getMinNumberOfProtons() {
        return this._minNumberOfProtons;
    }

    public int getMaxNumberOfProtons() {
        return this._maxNumberOfProtons;
    }

    public void setNumberOfNeutrons(int n) {
        if (n < this._minNumberOfNeutrons || n > this._maxNumberOfNeutrons) {
            throw new IllegalArgumentException("numberOfNeutrons is out of range: " + n);
        }
        if (n != this._numberOfNeutrons) {
            this._numberOfNeutrons = n;
            this.notifyObservers("numberOfNeutrons");
        }
    }

    public int getNumberOfNeutrons() {
        return this._numberOfNeutrons;
    }

    public int getMinNumberOfNeutrons() {
        return this._minNumberOfNeutrons;
    }

    public int getMaxNumberOfNeutrons() {
        return this._maxNumberOfNeutrons;
    }

    public Point2D getElectronOffsetRef() {
        return this._electronOffset;
    }

    public void moveAlphaParticle(double d, AlphaParticle alphaParticle) {
        RutherfordScattering.moveParticle(d, alphaParticle, this, this._boxSize);
    }

    public void stepInTime(double d) {
        double d2 = d * this._angularSpeed;
        this._electronAngle -= d2;
        double d3 = this._electronOrbitRadius * Math.sin(this._electronAngle);
        double d4 = this._electronOrbitRadius * Math.cos(this._electronAngle);
        this._electronOffset.setLocation(d3, d4);
        this.notifyObservers("electronOffset");
    }
}

