/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.rutherfordscattering.event.GunFiredEvent;
import edu.colorado.phet.rutherfordscattering.event.GunFiredListener;
import edu.colorado.phet.rutherfordscattering.model.AlphaParticle;
import edu.colorado.phet.rutherfordscattering.model.FixedObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Random;
import javax.swing.event.EventListenerList;

public class Gun
extends FixedObject
implements ModelElement {
    private boolean _enabled;
    private boolean _running;
    private double _nozzleWidth;
    private double _intensity;
    private double _speed;
    private final double _defaultSpeed;
    private final double _minSpeed;
    private final double _maxSpeed;
    private final Color _beamColor;
    private final Dimension _boxSize;
    private int _maxParticles;
    private double _dtPerGunFired;
    private double _dtSinceGunFired;
    private Random _randomPosition;
    private Random _randomSign;
    private EventListenerList _listenerList;
    private AffineTransform _transform;

    public Gun(Point2D point2D, double d, double d2, DoubleRange doubleRange, Color color, Dimension dimension) {
        super(point2D, d);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("invalid nozzleWidth: " + d2);
        }
        this._enabled = false;
        this._running = true;
        this._nozzleWidth = d2;
        this._defaultSpeed = this._speed = doubleRange.getDefault();
        this._minSpeed = doubleRange.getMin();
        this._maxSpeed = doubleRange.getMax();
        this._beamColor = color;
        this._boxSize = new Dimension(dimension);
        this._intensity = 1.0;
        this._randomPosition = new Random();
        this._randomSign = new Random();
        this._dtSinceGunFired = 0.0;
        this.setMaxParticles(20);
        this._listenerList = new EventListenerList();
        this._transform = new AffineTransform();
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            this.notifyObservers("enabled");
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setRunning(boolean bl) {
        this._running = bl;
    }

    public double getNozzleWidth() {
        return this._nozzleWidth;
    }

    public void setIntensity(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("invalid intensity: " + d);
        }
        if (d != this._intensity) {
            this._intensity = d;
            this.notifyObservers("intensity");
        }
    }

    public void setMaxParticles(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("invalid maxParticles: " + n);
        }
        this._maxParticles = n;
        this._dtPerGunFired = (double)this._boxSize.height / this._defaultSpeed / (double)n;
    }

    public void setSpeed(double d) {
        if (d < this._minSpeed || d > this._maxSpeed) {
            throw new IllegalArgumentException("invalid speed: " + d);
        }
        if (d != this._speed) {
            this._speed = d;
            this.notifyObservers("speed");
        }
    }

    public double getSpeed() {
        return this._speed;
    }

    public double getMinSpeed() {
        return this._minSpeed;
    }

    public double getMaxSpeed() {
        return this._maxSpeed;
    }

    public Color getBeamColor() {
        Color color = null;
        if (this._enabled) {
            Color color2 = this._beamColor;
            int n = (int)(this._intensity * 255.0);
            color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), n);
        }
        return color;
    }

    private Point2D getRandomNozzlePoint() {
        int n = this._randomSign.nextBoolean() ? 1 : -1;
        double d = 1.0;
        double d2 = (double)n * (10.0 + this._randomPosition.nextDouble() * (this._nozzleWidth / 2.0 - 10.0));
        if (!(Math.abs(d2) >= 10.0)) {
            System.out.println("y=" + d2);
            System.out.println("ySign=" + n);
            System.out.println("nozzleWidth=" + this._nozzleWidth);
            System.out.println("Y_ABSOLUTE_MIN=10.0");
        }
        assert (Math.abs(d2) >= 10.0);
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this._transform.setToIdentity();
        this._transform.rotate(this.getOrientation());
        this._transform.transform(double_, double_);
        ((Point2D)double_).setLocation(((Point2D)double_).getX() + this.getX(), ((Point2D)double_).getY() + this.getY());
        return double_;
    }

    public void stepInTime(double d) {
        if (this._enabled && this._running && this._intensity > 0.0) {
            this.fireAlphaParticle(d);
        }
    }

    private void fireAlphaParticle(double d) {
        this._dtSinceGunFired += this._intensity * d;
        if (this._dtSinceGunFired >= this._dtPerGunFired) {
            this._dtSinceGunFired %= this._dtPerGunFired;
            Point2D point2D = this.getRandomNozzlePoint();
            double d2 = this.getOrientation();
            AlphaParticle alphaParticle = new AlphaParticle(point2D, d2, this._speed, this._defaultSpeed);
            GunFiredEvent gunFiredEvent = new GunFiredEvent(this, alphaParticle);
            this.fireAlphaParticleFiredEvent(gunFiredEvent);
        }
    }

    public void addGunFiredListener(GunFiredListener gunFiredListener) {
        this._listenerList.add(GunFiredListener.class, gunFiredListener);
    }

    private void fireAlphaParticleFiredEvent(GunFiredEvent gunFiredEvent) {
        assert (gunFiredEvent.getAlphaParticle() != null);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != GunFiredListener.class) continue;
            ((GunFiredListener)objectArray[i + 1]).alphaParticleFired(gunFiredEvent);
        }
    }
}

