/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rutherfordscattering.control;

import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.rutherfordscattering.RSConstants;
import edu.colorado.phet.rutherfordscattering.RSResources;
import edu.colorado.phet.rutherfordscattering.control.RSAbstractControlPanel;
import edu.colorado.phet.rutherfordscattering.model.Gun;
import edu.colorado.phet.rutherfordscattering.module.PlumPuddingAtomModule;
import edu.colorado.phet.rutherfordscattering.view.LegendPanel;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlumPuddingAtomControlPanel
extends RSAbstractControlPanel
implements Observer {
    private PlumPuddingAtomModule _module;
    private Gun _gun;
    private LinearValueControl _energyControl;
    private ChangeListener _energyListener;
    private JCheckBox _tracesCheckBox;

    public PlumPuddingAtomControlPanel(PlumPuddingAtomModule plumPuddingAtomModule) {
        super(plumPuddingAtomModule);
        this._module = plumPuddingAtomModule;
        this._gun = this._module.getGun();
        this._gun.addObserver(this);
        LegendPanel legendPanel = new LegendPanel(0.85, RSConstants.TITLE_FONT, RSConstants.CONTROL_FONT, RSConstants.TITLED_BORDER_STYLE);
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = new TitledBorder(RSResources.getString("string.alphaParticleProperties"));
        titledBorder.setTitleFont(RSConstants.TITLE_FONT);
        titledBorder.setBorder(RSConstants.TITLED_BORDER_STYLE);
        jPanel.setBorder(titledBorder);
        double d = this._gun.getSpeed();
        double d2 = this._gun.getMinSpeed();
        double d3 = this._gun.getMaxSpeed();
        String string = "0";
        String string2 = RSResources.getString("string.energy");
        String string3 = "";
        this._energyControl = new LinearValueControl(d2, d3, string2, string, string3);
        this._energyControl.setValue(d);
        this._energyControl.setFont(RSConstants.CONTROL_FONT);
        this._energyControl.setTextFieldEditable(true);
        this._energyControl.setTextFieldVisible(false);
        this._energyControl.addTickLabel(d2, RSResources.getString("string.minEnergy"));
        this._energyControl.addTickLabel(d3, RSResources.getString("string.maxEnergy"));
        this._energyListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PlumPuddingAtomControlPanel.this._module.removeAllAlphaParticles();
                PlumPuddingAtomControlPanel.this._gun.setRunning(false);
                if (!PlumPuddingAtomControlPanel.this._energyControl.isAdjusting()) {
                    PlumPuddingAtomControlPanel.this.handleEnergyChange();
                    PlumPuddingAtomControlPanel.this._gun.setRunning(true);
                }
            }
        };
        this._energyControl.addChangeListener(this._energyListener);
        this._tracesCheckBox = new JCheckBox(RSResources.getString("string.showTraces"));
        this._tracesCheckBox.setFont(RSConstants.CONTROL_FONT);
        this._tracesCheckBox.setSelected(this._module.getTracesNode().isEnabled());
        this._tracesCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PlumPuddingAtomControlPanel.this.handleTracesChanged();
            }
        });
        Serializable serializable = new EasyGridBagLayout(jPanel);
        jPanel.setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setAnchor(17);
        int n = 0;
        int n2 = 0;
        ((EasyGridBagLayout)serializable).addComponent(this._energyControl, n++, n2);
        ((EasyGridBagLayout)serializable).addFilledComponent(new JSeparator(), n++, n2, 2);
        ((EasyGridBagLayout)serializable).addComponent(this._tracesCheckBox, n++, n2);
        this.addControlFullWidth(legendPanel);
        this.addVerticalSpace(20);
        this.addControlFullWidth(jPanel);
        this.addVerticalSpace(20);
        serializable = this.addResetAllButton(plumPuddingAtomModule);
        ((JComponent)serializable).setFont(RSConstants.CONTROL_FONT);
    }

    public void setTracesEnabled(boolean bl) {
        this._tracesCheckBox.setSelected(bl);
    }

    private void handleEnergyChange() {
        this._module.removeAllAlphaParticles();
        this._gun.setRunning(false);
        double d = this._energyControl.getValue();
        this._gun.deleteObserver(this);
        this._gun.setSpeed(d);
        this._gun.addObserver(this);
        if (!this._energyControl.isAdjusting()) {
            this._gun.setRunning(true);
        }
    }

    private void handleTracesChanged() {
        boolean bl = this._tracesCheckBox.isSelected();
        this._module.getTracesNode().setEnabled(bl);
    }

    public void update(Observable observable, Object object) {
        if (observable == this._gun && object == "speed") {
            this._energyControl.removeChangeListener(this._energyListener);
            this._energyControl.setValue(this._gun.getSpeed());
            this._energyControl.addChangeListener(this._energyListener);
        }
    }
}

