/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.keyvalue;

import java.io.Serializable;
import java.util.Arrays;

public class MultiKey
implements Serializable {
    private final Object[] keys;
    private final int hashCode;

    public MultiKey(Object key1, Object key2) {
        this(new Object[]{key1, key2}, false);
    }

    public MultiKey(Object[] keys, boolean makeClone) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = makeClone ? (Object[])keys.clone() : keys;
        int total = 0;
        int i = 0;
        while (i < keys.length) {
            if (keys[i] != null) {
                total ^= keys[i].hashCode();
            }
            ++i;
        }
        this.hashCode = total;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey otherMulti = (MultiKey)other;
            return Arrays.equals(this.keys, otherMulti.keys);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "MultiKey" + Arrays.asList(this.keys).toString();
    }
}

