/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class PPath
extends PNode {
    private static final Rectangle2D.Float TEMP_RECTANGLE = new Rectangle2D.Float();
    private static final RoundRectangle2D.Float TEMP_ROUNDRECTANGLE = new RoundRectangle2D.Float();
    private static final Ellipse2D.Float TEMP_ELLIPSE = new Ellipse2D.Float();
    private static final PAffineTransform TEMP_TRANSFORM = new PAffineTransform();
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Color DEFAULT_STROKE_PAINT = Color.black;
    private transient GeneralPath path;
    private transient GeneralPath resizePath;
    private transient Stroke stroke;
    private transient boolean updatingBoundsFromPath;
    private Paint strokePaint = DEFAULT_STROKE_PAINT;

    public PPath() {
        this.stroke = DEFAULT_STROKE;
        this.path = new GeneralPath();
    }

    public PPath(Shape shape) {
        this(shape, DEFAULT_STROKE);
    }

    public PPath(Shape shape, Stroke stroke) {
        this();
        this.stroke = stroke;
        if (shape != null) {
            this.append(shape, false);
        }
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Paint paint) {
        Paint paint2 = this.strokePaint;
        this.strokePaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(65536, "strokePaint", paint2, this.strokePaint);
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.updateBoundsFromPath();
        this.invalidatePaint();
        this.firePropertyChange(131072, "stroke", stroke2, this.stroke);
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        if (this.updatingBoundsFromPath || this.path == null) {
            return;
        }
        if (this.resizePath != null) {
            this.path.reset();
            this.path.append(this.resizePath, false);
        }
        Rectangle2D rectangle2D = this.path.getBounds2D();
        Rectangle2D rectangle2D2 = this.getPathBoundsWithStroke();
        double d5 = Math.max(rectangle2D2.getWidth() - rectangle2D.getWidth(), rectangle2D2.getHeight() - rectangle2D.getHeight());
        double d6 = d + d5 / 2.0;
        double d7 = d2 + d5 / 2.0;
        double d8 = d3 - d5;
        double d9 = d4 - d5;
        double d10 = d8 == 0.0 || rectangle2D.getWidth() == 0.0 ? 1.0 : d8 / rectangle2D.getWidth();
        double d11 = d9 == 0.0 || rectangle2D.getHeight() == 0.0 ? 1.0 : d9 / rectangle2D.getHeight();
        TEMP_TRANSFORM.setToIdentity();
        TEMP_TRANSFORM.translate(d6, d7);
        TEMP_TRANSFORM.scale(d10, d11);
        TEMP_TRANSFORM.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.path.transform(TEMP_TRANSFORM);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (super.intersects(rectangle2D)) {
            if (this.getPaint() != null && this.path.intersects(rectangle2D)) {
                return true;
            }
            if (this.stroke != null && this.strokePaint != null) {
                return this.stroke.createStrokedShape(this.path).intersects(rectangle2D);
            }
        }
        return false;
    }

    public Rectangle2D getPathBoundsWithStroke() {
        if (this.stroke != null) {
            return this.stroke.createStrokedShape(this.path).getBounds2D();
        }
        return this.path.getBounds2D();
    }

    public void updateBoundsFromPath() {
        this.updatingBoundsFromPath = true;
        if (this.path == null) {
            this.resetBounds();
        } else {
            Rectangle2D rectangle2D = this.getPathBoundsWithStroke();
            this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        this.updatingBoundsFromPath = false;
    }

    protected void paint(PPaintContext pPaintContext) {
        Paint paint = this.getPaint();
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(this.path);
        }
        if (this.stroke != null && this.strokePaint != null) {
            graphics2D.setPaint(this.strokePaint);
            graphics2D.setStroke(this.stroke);
            graphics2D.draw(this.path);
        }
    }

    public GeneralPath getPathReference() {
        return this.path;
    }

    public void append(Shape shape, boolean bl) {
        this.path.append(shape, bl);
        this.firePropertyChange(262144, "path", null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }

    public void setPathTo(Shape shape) {
        this.path.reset();
        this.append(shape, false);
    }

    public void setPathToRectangle(float f, float f2, float f3, float f4) {
        TEMP_RECTANGLE.setFrame(f, f2, f3, f4);
        this.setPathTo(TEMP_RECTANGLE);
    }

    public void setPathToEllipse(float f, float f2, float f3, float f4) {
        TEMP_ELLIPSE.setFrame(f, f2, f3, f4);
        this.setPathTo(TEMP_ELLIPSE);
    }

    public void reset() {
        this.path.reset();
        this.firePropertyChange(262144, "path", null, this.path);
        this.updateBoundsFromPath();
        this.invalidatePaint();
    }
}

