/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.icons;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ReactionSelectorIcons {
    private static ImageIcon DEFAULT_ICON;
    private static ImageIcon R1_ICON;
    private static ImageIcon R2_ICON;
    private static ImageIcon R3_ICON;
    private static PImage aNode;
    private static PImage bcNode;
    private static Map reactionToIconMap;

    public static ImageIcon getIcon(EnergyProfile energyProfile) {
        ImageIcon imageIcon = (ImageIcon)reactionToIconMap.get(energyProfile);
        if (imageIcon == null) {
            throw new RuntimeException("internal error");
        }
        return imageIcon;
    }

    private static void createImages() {
        DEFAULT_ICON = new ImageIcon(ReactionSelectorIcons.createImage(Profiles.DEFAULT));
        R1_ICON = new ImageIcon(ReactionSelectorIcons.createImage(Profiles.R1));
        R2_ICON = new ImageIcon(ReactionSelectorIcons.createImage(Profiles.R2));
        R3_ICON = new ImageIcon(ReactionSelectorIcons.createImage(Profiles.R3));
    }

    private static Image createImage(EnergyProfile energyProfile) {
        ReactionSelectorIcons.setMoleculeImages(energyProfile);
        PhetFont phetFont = new PhetFont(1, 18);
        PText pText = new PText("+");
        pText.setTextPaint(Color.black);
        pText.setFont(phetFont);
        PNode pNode = new PNode();
        pNode.addChild(aNode);
        pNode.addChild(pText);
        pNode.addChild(bcNode);
        pText.setOffset(aNode.getFullBounds().getWidth() + 3.0, (aNode.getFullBounds().getHeight() - pText.getFullBounds().getHeight()) / 2.0);
        bcNode.setOffset(pText.getOffset().getX() + pText.getFullBounds().getWidth() + 3.0, (aNode.getFullBounds().getHeight() - bcNode.getFullBounds().getHeight()) / 2.0);
        return pNode.toImage();
    }

    private static void setMoleculeImages(EnergyProfile energyProfile) {
        aNode.setImage(new MoleculeIcon(MoleculeA.class, energyProfile).getImage());
        bcNode.setImage(new MoleculeIcon(MoleculeBC.class, energyProfile).getImage());
    }

    static {
        aNode = new PImage();
        bcNode = new PImage();
        reactionToIconMap = new HashMap();
        ReactionSelectorIcons.createImages();
        reactionToIconMap.put(Profiles.DEFAULT, DEFAULT_ICON);
        reactionToIconMap.put(Profiles.R1, R1_ICON);
        reactionToIconMap.put(Profiles.R2, R2_ICON);
        reactionToIconMap.put(Profiles.R3, R3_ICON);
    }
}

