/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.factories;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

public class TextureImageFactory {
    public static Paint createTexturePaint(Color color, Color color2, double d) {
        return TextureImageFactory.newTexturePaint(TextureImageFactory.createTextureImage(color, color2, 400, d));
    }

    public static BufferedImage createTextureImage(Color color, Color color2, int n, double d) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n);
        BasicStroke basicStroke = new BasicStroke((float)d);
        graphics2D.setColor(color2);
        graphics2D.setStroke(basicStroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d2 = (double)n / (d * Math.sqrt(2.0));
        double d3 = 2.0 * (double)n / d2;
        int n2 = 0;
        while ((double)n2 < d2 + 1.0) {
            double d4 = (double)n2 * d3 - (double)n - d;
            double d5 = 0.0 - d;
            double d6 = d4 + (double)n + d;
            double d7 = (double)n + d;
            graphics2D.draw(new Line2D.Double(d4, d5, d6, d7));
            ++n2;
        }
        return bufferedImage;
    }

    private static Paint newTexturePaint(BufferedImage bufferedImage) {
        return new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }
}

