/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.common.phetcommon.util.DynamicListenerController;
import edu.colorado.phet.common.phetcommon.util.DynamicListenerControllerFactory;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.SelectedMoleculeTracker;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.modules.MRModule;

public class MoleculeSelectionTracker {
    private final DynamicListenerController listenerController = DynamicListenerControllerFactory.newController(MoleculeSelectionListener.class);
    private MRModel mrModel;
    private SelectedMoleculeListener moleculeListener = new SelectedMoleculeListener();

    public MoleculeSelectionTracker(MRModule mRModule) {
        this.mrModel = mRModule.getMRModel();
        this.mrModel.addListener(this.moleculeListener);
        this.mrModel.addSelectedMoleculeTrackerListener(this.moleculeListener);
    }

    public void terminate() {
        this.mrModel.removeListener(this.moleculeListener);
        this.mrModel.removeSelectedMoleculeTrackerListener(this.moleculeListener);
    }

    public SimpleMolecule getBoundMolecule() {
        SimpleMolecule simpleMolecule = null;
        if (this.getSelectedMolecule() != null && this.getNearestToSelectedMolecule() != null) {
            if (this.getSelectedMolecule().isPartOfComposite()) {
                simpleMolecule = this.getSelectedMolecule();
            } else if (this.getNearestToSelectedMolecule().isPartOfComposite()) {
                simpleMolecule = this.getNearestToSelectedMolecule();
            }
        }
        return simpleMolecule;
    }

    public SimpleMolecule getFreeMolecule() {
        SimpleMolecule simpleMolecule = null;
        if (this.getSelectedMolecule() != null && this.getNearestToSelectedMolecule() != null) {
            if (this.getSelectedMolecule().isPartOfComposite()) {
                if (!this.getNearestToSelectedMolecule().isPartOfComposite()) {
                    simpleMolecule = this.getNearestToSelectedMolecule();
                }
            } else if (this.getNearestToSelectedMolecule().isPartOfComposite() && !this.getSelectedMolecule().isPartOfComposite()) {
                simpleMolecule = this.getSelectedMolecule();
            }
        }
        return simpleMolecule;
    }

    public SimpleMolecule getSelectedMolecule() {
        return this.mrModel.getMoleculeBeingTracked();
    }

    public SimpleMolecule getNearestToSelectedMolecule() {
        return this.mrModel.getNearestToMoleculeBeingTracked();
    }

    public boolean isTracking() {
        return this.getFreeMolecule() != null && this.getBoundMolecule() != null && this.getSelectedMolecule() != null && this.getNearestToSelectedMolecule() != null;
    }

    private MoleculeSelectionListener getSelectionListenerController() {
        return (MoleculeSelectionListener)((Object)this.listenerController);
    }

    public void reset() {
    }

    public static interface MoleculeSelectionListener {
        public void notifySelectedChanged(SimpleMolecule var1, SimpleMolecule var2);

        public void notifyClosestChanged(SimpleMolecule var1, SimpleMolecule var2);

        public void notifyEnergyProfileChanged(EnergyProfile var1);
    }

    private class SelectedMoleculeListener
    extends MRModel.ModelListenerAdapter
    implements SelectedMoleculeTracker.Listener {
        private SelectedMoleculeListener() {
        }

        public void moleculeBeingTrackedChanged(SimpleMolecule simpleMolecule, SimpleMolecule simpleMolecule2) {
            MoleculeSelectionTracker.this.getSelectionListenerController().notifySelectedChanged(simpleMolecule2, simpleMolecule);
        }

        public void closestMoleculeChanged(SimpleMolecule simpleMolecule, SimpleMolecule simpleMolecule2) {
            MoleculeSelectionTracker.this.getSelectionListenerController().notifyClosestChanged(simpleMolecule2, simpleMolecule);
        }

        public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
            MoleculeSelectionTracker.this.getSelectionListenerController().notifyEnergyProfileChanged(energyProfile);
        }
    }
}

