/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.energy;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.AxisNode;
import edu.colorado.phet.reactionsandrates.view.energy.EnergyCursor;
import edu.colorado.phet.reactionsandrates.view.energy.EnergyLine;
import edu.colorado.phet.reactionsandrates.view.energy.EnergyProfileGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;

public class CurvePane
extends PPath
implements Resetable {
    private final Color energyPaneBackgroundColor = MRConfig.ENERGY_PANE_BACKGROUND;
    private final Color curveColor = MRConfig.POTENTIAL_ENERGY_COLOR;
    private final Insets curveAreaInsets = new Insets(20, 30, 40, 10);
    private final Dimension curvePaneSize;
    private final Dimension curveAreaSize;
    private volatile EnergyProfileGraphic energyProfileGraphic;
    private volatile EnergyLine energyLine;
    private EnergyCursor energyCursor;
    private MRModel mrModel;
    private CurveCreatingModelListener curveCreatingModelListener;

    public CurvePane(MRModule mRModule, Dimension dimension) {
        super(new Rectangle2D.Double(0.0, 0.0, dimension.width - 1, (int)MRConfig.ENERGY_VIEW_SIZE.getHeight() - dimension.height - MRConfig.ENERGY_VIEW_REACTION_LEGEND_SIZE.height));
        this.mrModel = mRModule.getMRModel();
        this.curvePaneSize = new Dimension(dimension.width, (int)MRConfig.ENERGY_VIEW_SIZE.getHeight() - dimension.height - MRConfig.ENERGY_VIEW_REACTION_LEGEND_SIZE.height);
        this.curveAreaSize = new Dimension((int)this.curvePaneSize.getWidth() - this.curveAreaInsets.left - this.curveAreaInsets.right, (int)this.curvePaneSize.getHeight() - this.curveAreaInsets.top - this.curveAreaInsets.bottom);
        PNode pNode = new PNode();
        pNode.setOffset(this.curveAreaInsets.left, this.curveAreaInsets.top);
        PNode pNode2 = new PNode();
        pNode2.setOffset(this.curveAreaInsets.left, this.curveAreaInsets.top);
        pNode2.setWidth(this.curveAreaSize.getWidth());
        pNode2.setHeight(this.curveAreaSize.getHeight());
        PNode pNode3 = new PNode();
        pNode3.setOffset(this.curveAreaInsets.left, this.curveAreaInsets.top);
        this.setOffset(0.0, dimension.getHeight());
        this.setPaint(this.energyPaneBackgroundColor);
        this.setStrokePaint(new Color(0, 0, 0, 0));
        this.addChild(pNode2);
        this.addChild(pNode3);
        this.addChild(pNode);
        this.energyLine = new EnergyLine(this.curveAreaSize, mRModule, mRModule.getClock());
        pNode.addChild(this.energyLine);
        this.createCurve(this.mrModel, pNode2);
        this.curveCreatingModelListener = new CurveCreatingModelListener(this.mrModel, pNode2);
        this.mrModel.addListener(this.curveCreatingModelListener);
        this.energyCursor = new EnergyCursor(this.curveAreaSize.getHeight(), 0.0, this.curveAreaSize.getWidth(), this.mrModel);
        this.energyCursor.setVisible(false);
        pNode3.addChild(this.energyCursor);
        AxisNode axisNode = new AxisNode(MRConfig.RESOURCES.getLocalizedString("EnergyView.ReactionCoordinate"), this.curveAreaSize.getWidth(), MRConfig.ENERGY_PANE_TEXT_COLOR, AxisNode.HORIZONTAL, AxisNode.BOTTOM);
        axisNode.setOffset(this.curveAreaInsets.left - 2, this.getHeight() - 25.0);
        this.addChild(axisNode);
        AxisNode axisNode2 = new AxisNode("Energy", 200.0, MRConfig.ENERGY_PANE_TEXT_COLOR, AxisNode.VERTICAL, AxisNode.TOP);
        axisNode2.setOffset(this.curveAreaInsets.left - 2, this.getHeight() - 25.0);
        this.addChild(axisNode2);
    }

    public void reset() {
        this.energyLine.reset();
    }

    public void terminate() {
        this.mrModel.removeListener(this.curveCreatingModelListener);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public Dimension getSize() {
        return this.curvePaneSize;
    }

    public Dimension getCurveAreaSize() {
        return this.curveAreaSize;
    }

    public void setEnergyLineLabel(String string) {
        this.energyLine.setLabel(string);
    }

    public void setEnergyCursorOffset(double d) {
        this.energyCursor.setOffset(d, 0.0);
    }

    private void createCurve(MRModel mRModel, PNode pNode) {
        if (this.energyProfileGraphic != null) {
            try {
                pNode.removeChild(this.energyProfileGraphic);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.energyProfileGraphic = new EnergyProfileGraphic(mRModel.getEnergyProfile(), this.curveAreaSize, this.curveColor);
        pNode.addChild(this.energyProfileGraphic);
    }

    public void setProfileManipulable(boolean bl) {
        this.energyProfileGraphic.setManipulable(bl);
    }

    public double getIntersectionWithHorizontal(double d) {
        return this.energyProfileGraphic.getIntersectionWithHorizontal(this.energyLine.getEnergyLineY(), d);
    }

    public void setEnergyCursorVisible(boolean bl) {
        this.energyCursor.setVisible(bl);
    }

    private class CurveCreatingModelListener
    extends MRModel.ModelListenerAdapter {
        private final MRModel model;
        private final PNode curveLayer;

        public CurveCreatingModelListener(MRModel mRModel, PNode pNode) {
            this.model = mRModel;
            this.curveLayer = pNode;
        }

        public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
            CurvePane.this.createCurve(this.model, this.curveLayer);
        }
    }
}

