/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.modules.ComplexModule;
import edu.colorado.phet.reactionsandrates.view.MoleculePaints;
import edu.colorado.phet.reactionsandrates.view.charts.MoleculePopulationsPieChart;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;

public class MoleculePopulationsPieChartNode
extends PNode {
    private PPath mAPaintNode;
    private PPath mBCPaintNode;
    private PPath mABPaintNode;
    private PPath mCPaintNode;

    public MoleculePopulationsPieChartNode(ComplexModule complexModule, Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D);
        this.createLegend(complexModule.getMRModel(), rectangle2D);
        MoleculePopulationsPieChart moleculePopulationsPieChart = new MoleculePopulationsPieChart(complexModule, rectangle2D, 1.0);
        this.addChild(moleculePopulationsPieChart);
        moleculePopulationsPieChart.setOffset(-rectangle2D.getWidth() / 6.0, 0.0);
        PText pText = new PText(MRConfig.RESOURCES.getLocalizedString("StripChart.title"));
        pText.setFont(MRConfig.CHART_TITLE_FONT);
        this.addChild(pText);
        double d = rectangle2D.getWidth() - pText.getFullBounds().getWidth() - 20.0;
        pText.setOffset(d, pText.getFullBounds().getHeight() / 2.0);
    }

    private void createLegend(MRModel mRModel, Rectangle2D rectangle2D) {
        double d = 15.0;
        double d2 = 10.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, -d2 / 2.0, d, d2);
        this.mAPaintNode = new PPath(double_);
        this.mBCPaintNode = new PPath(double_);
        this.mABPaintNode = new PPath(double_);
        this.mCPaintNode = new PPath(double_);
        EnergyProfile energyProfile = mRModel.getEnergyProfile();
        this.setLegendMoleculePaints(energyProfile);
        mRModel.addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculePopulationsPieChartNode.this.setLegendMoleculePaints(energyProfile);
            }
        });
        PText pText = new PText("A");
        PText pText2 = new PText("BC");
        PText pText3 = new PText("AB");
        PText pText4 = new PText("C");
        this.addChild(this.mAPaintNode);
        this.addChild(this.mBCPaintNode);
        this.addChild(this.mABPaintNode);
        this.addChild(this.mCPaintNode);
        this.addChild(pText);
        this.addChild(pText2);
        this.addChild(pText3);
        this.addChild(pText4);
        this.addChild(new PPath(rectangle2D));
        Insets insets = new Insets(5, 0, 5, 80);
        Insets insets2 = new Insets(5, 0, 5, 50);
        double d3 = 50.0;
        double d4 = -5.0;
        this.mAPaintNode.setOffset(rectangle2D.getWidth() - (double)insets.right, d3);
        pText.setOffset(rectangle2D.getWidth() - (double)insets2.right, d3 + d4);
        this.mBCPaintNode.setOffset(rectangle2D.getWidth() - (double)insets.right, d3 += (double)(insets.top + insets.bottom + 10));
        pText2.setOffset(rectangle2D.getWidth() - (double)insets2.right, d3 + d4);
        this.mABPaintNode.setOffset(rectangle2D.getWidth() - (double)insets.right, d3 += (double)(insets.top + insets.bottom + 10));
        pText3.setOffset(rectangle2D.getWidth() - (double)insets2.right, d3 + d4);
        this.mCPaintNode.setOffset(rectangle2D.getWidth() - (double)insets.right, d3 += (double)(insets.top + insets.bottom + 10));
        pText4.setOffset(rectangle2D.getWidth() - (double)insets2.right, d3 + d4);
    }

    private void setLegendMoleculePaints(EnergyProfile energyProfile) {
        this.mAPaintNode.setPaint(MoleculePaints.getPaint(MoleculeA.class, energyProfile));
        this.mBCPaintNode.setPaint(MoleculePaints.getPaint(MoleculeBC.class, energyProfile));
        this.mABPaintNode.setPaint(MoleculePaints.getPaint(MoleculeAB.class, energyProfile));
        this.mCPaintNode.setPaint(MoleculePaints.getPaint(MoleculeC.class, energyProfile));
    }
}

