/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view.charts;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.Selectable;
import edu.colorado.phet.reactionsandrates.modules.ComplexModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class ChartOptionsPanel
extends JPanel
implements Resetable {
    public static final Option BAR_CHART_OPTION = new Option();
    public static final Option PIE_CHART_OPTION = new Option();
    public static final Option STRIP_CHART_OPTION = new Option();
    public static final Option NO_CHART_OPTION = new Option();
    private ComplexModule module;
    private JToggleButton showBondsBtn;
    private JToggleButton showStopwatchBtn;
    private JToggleButton showStripChartBtn;
    private JToggleButton showPieChartBtn;
    private JToggleButton showBarChartBtn;
    private JToggleButton showNoneBtn;

    public ChartOptionsPanel(final ComplexModule complexModule) {
        this.module = complexModule;
        this.showBondsBtn = new JCheckBox(MRConfig.RESOURCES.getLocalizedString("Control.showBonds"));
        this.showBondsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                complexModule.setGraphicTypeVisible(ChartOptionsPanel.this.showBondsBtn.isSelected());
            }
        });
        this.showBondsBtn.setSelected(false);
        complexModule.setGraphicTypeVisible(this.showBondsBtn.isSelected());
        this.showStopwatchBtn = new JCheckBox(MRConfig.RESOURCES.getLocalizedString("Control.showStopwatch"));
        this.showStopwatchBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                complexModule.setStopwatchVisible(ChartOptionsPanel.this.showStopwatchBtn.isSelected());
            }
        });
        this.showBondsBtn.setSelected(false);
        complexModule.setStopwatchVisible(this.showStopwatchBtn.isSelected());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(ControlBorderFactory.createSecondaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.chartOptions")));
        Cloneable cloneable = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        Serializable serializable = new ButtonGroup();
        this.showBarChartBtn = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.showBarChart"));
        this.showBarChartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartOptionsPanel.this.setEnergyViewChartOptions();
            }
        });
        serializable.add(this.showBarChartBtn);
        this.showPieChartBtn = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.showPieChart"));
        this.showPieChartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartOptionsPanel.this.setEnergyViewChartOptions();
            }
        });
        serializable.add(this.showPieChartBtn);
        this.showStripChartBtn = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.showStripChart"));
        this.showStripChartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartOptionsPanel.this.setEnergyViewChartOptions();
            }
        });
        serializable.add(this.showStripChartBtn);
        this.showNoneBtn = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.none"));
        this.showNoneBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChartOptionsPanel.this.setEnergyViewChartOptions();
            }
        });
        this.showNoneBtn.setSelected(true);
        serializable.add(this.showNoneBtn);
        cloneable.gridy = 0;
        jPanel.add((Component)this.showBarChartBtn, cloneable);
        cloneable.gridx = 1;
        jPanel.add((Component)this.showStripChartBtn, cloneable);
        cloneable.gridx = 0;
        cloneable.gridy = 1;
        jPanel.add((Component)this.showPieChartBtn, cloneable);
        cloneable.gridx = 1;
        jPanel.add((Component)this.showNoneBtn, cloneable);
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.options")));
        this.setLayout(new GridBagLayout());
        cloneable = new Insets(0, 0, 0, 0);
        serializable = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, (Insets)cloneable, 0, 0);
        this.add((Component)jPanel, serializable);
        ((GridBagConstraints)serializable).fill = 0;
        ((GridBagConstraints)serializable).anchor = 17;
        this.add((Component)this.showBondsBtn, serializable);
        this.add((Component)this.showStopwatchBtn, serializable);
    }

    private void setEnergyViewChartOptions() {
        this.module.setBarChartVisible(this.showBarChartBtn.isSelected());
        this.module.setPieChartVisible(this.showPieChartBtn.isSelected());
        this.module.setStripChartVisible(this.showStripChartBtn.isSelected());
        if (this.showStripChartBtn.isSelected()) {
            // empty if block
        }
        if (this.showNoneBtn.isSelected() && this.module.getMRModel().getMoleculeBeingTracked() != null) {
            this.module.getMRModel().getMoleculeBeingTracked().setSelectionStatus(Selectable.NOT_SELECTED);
        }
        this.module.setStopwatchVisible(this.showStopwatchBtn.isSelected());
    }

    public void reset() {
        this.showStripChartBtn.setSelected(false);
        this.showNoneBtn.setSelected(true);
        this.showBondsBtn.setSelected(false);
        this.module.setGraphicTypeVisible(this.showBondsBtn.isSelected());
        this.showStopwatchBtn.setSelected(false);
        this.setEnergyViewChartOptions();
    }

    public static class Option {
        private Option() {
        }
    }
}

