/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.collision.Box2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.TemperatureControl;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.ModelElementGraphicManager;
import edu.colorado.phet.reactionsandrates.view.BondGraphic;
import edu.colorado.phet.reactionsandrates.view.BoxGraphic;
import edu.colorado.phet.reactionsandrates.view.ProvisionalBondGraphic;
import edu.colorado.phet.reactionsandrates.view.ReactionGraphic;
import edu.colorado.phet.reactionsandrates.view.TemperatureControlGraphic;
import edu.colorado.phet.reactionsandrates.view.ThermometerGraphic;
import edu.colorado.phet.reactionsandrates.view.factories.BondGraphicFactory;
import edu.colorado.phet.reactionsandrates.view.factories.CompositeMoleculeGraphicFactory;
import edu.colorado.phet.reactionsandrates.view.factories.ProvisionalBondGraphicFactory;
import edu.colorado.phet.reactionsandrates.view.factories.SimpleMoleculeGraphicFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class SpatialView
extends PNode {
    private Color background = MRConfig.SPATIAL_VIEW_BACKGROUND;
    private PNode moleculeLayer = new PNode();
    private PNode bondLayer = new PNode();
    private PNode boxLayer = new PNode();
    private PNode topLayer = new PNode();
    private ModelElementGraphicManager megm;
    private ThermometerGraphic thermometerGraphic;
    private MRModel model;

    public SpatialView(MRModule mRModule, Dimension dimension) {
        this.model = mRModule.getMRModel();
        PSwingCanvas pSwingCanvas = (PSwingCanvas)mRModule.getSimulationPanel();
        PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight()), new BasicStroke(1.0f));
        pPath.setPaint(this.background);
        this.addChild(pPath);
        this.addChild(this.moleculeLayer);
        this.addChild(this.bondLayer);
        this.addChild(this.boxLayer);
        this.addChild(this.topLayer);
        this.megm = new ModelElementGraphicManager(this.model, pPath);
        this.megm.addGraphicFactory(new SimpleMoleculeGraphicFactory(mRModule.getMRModel(), this.moleculeLayer));
        this.megm.addGraphicFactory(new BoxGraphicFactory());
        this.megm.addGraphicFactory(new CompositeMoleculeGraphicFactory(this.bondLayer));
        this.megm.addGraphicFactory(new ProvisionalBondGraphicFactory(this.bondLayer));
        this.megm.addGraphicFactory(new BondGraphicFactory(this.bondLayer));
        this.megm.addGraphicFactory(new TemperatureControlGraphicFactory(pSwingCanvas, this.bondLayer));
        this.megm.scanModel();
        ReactionGraphic reactionGraphic = new ReactionGraphic(this.model.getReaction(), Color.black, this.model);
        reactionGraphic.setOffset(this.model.getBox().getMinX() + this.model.getBox().getWidth() / 2.0, pPath.getHeight() - reactionGraphic.getHeight() - 20.0);
        pPath.addChild(reactionGraphic);
        this.thermometerGraphic = new ThermometerGraphic(this.model, mRModule.getClock(), 10.0, 300.0);
        this.thermometerGraphic.setOffset(this.model.getBox().getMaxX() + 8.0, this.model.getBox().getMinY() - 20.0);
        this.megm.addGraphic(this.thermometerGraphic, this.topLayer);
    }

    public void setGraphicTypeVisible(boolean bl) {
        this.megm.setAllOfTypeVisible(BondGraphic.class, bl);
        this.megm.setAllOfTypeVisible(ProvisionalBondGraphic.class, bl);
    }

    public void addGraphicFactory(ModelElementGraphicManager.GraphicFactory graphicFactory) {
        this.megm.addGraphicFactory(graphicFactory);
    }

    public PNode getTopLayer() {
        return this.topLayer;
    }

    public boolean isTemperatureBeingAdjusted() {
        boolean bl = false;
        List list = this.megm.getGraphicsForModelElementClass(TemperatureControl.class);
        for (int i = 0; i < list.size(); ++i) {
            TemperatureControlGraphic temperatureControlGraphic = (TemperatureControlGraphic)list.get(i);
            if (!temperatureControlGraphic.isTemperatureBeingAdjusted()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private class BoxGraphicFactory
    extends ModelElementGraphicManager.GraphicFactory {
        protected BoxGraphicFactory() {
            super(Box2D.class, SpatialView.this.boxLayer);
        }

        public PNode createGraphic(ModelElement modelElement) {
            BoxGraphic boxGraphic = new BoxGraphic((Box2D)modelElement);
            boxGraphic.setOffset(((Box2D)modelElement).getPosition());
            return boxGraphic;
        }
    }

    private class TemperatureControlGraphicFactory
    extends ModelElementGraphicManager.GraphicFactory {
        private PSwingCanvas pSwingCanvas;

        protected TemperatureControlGraphicFactory(PSwingCanvas pSwingCanvas, PNode pNode) {
            super(TemperatureControl.class, pNode);
            this.pSwingCanvas = pSwingCanvas;
        }

        public PNode createGraphic(ModelElement modelElement) {
            TemperatureControlGraphic temperatureControlGraphic = new TemperatureControlGraphic(this.pSwingCanvas, (TemperatureControl)modelElement);
            return temperatureControlGraphic;
        }
    }
}

