/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.view.MoleculePaints;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class SimpleMoleculeGraphicNode
extends PNode {
    private static BufferedImage A_IMAGE;
    private static BufferedImage B_IMAGE;
    private static BufferedImage C_IMAGE;
    private static BufferedImage A_LABEL_IMAGE;
    private static BufferedImage B_LABEL_IMAGE;
    private static BufferedImage C_LABEL_IMAGE;

    private static BufferedImage scaleImage(BufferedImage bufferedImage, double d) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        return affineTransformOp.filter(bufferedImage, null);
    }

    public SimpleMoleculeGraphicNode(Class clazz, EnergyProfile energyProfile) {
        this(clazz, energyProfile, false);
    }

    public SimpleMoleculeGraphicNode(Class clazz, EnergyProfile energyProfile, boolean bl) {
        this.createGraphics(clazz, bl, energyProfile);
    }

    private void createGraphics(Class clazz, boolean bl, EnergyProfile energyProfile) {
        PImage pImage;
        PImage pImage2 = null;
        if (clazz == MoleculeA.class) {
            pImage = new PImage(A_IMAGE);
            if (bl) {
                pImage2 = new PImage(A_LABEL_IMAGE);
            }
        } else if (clazz == MoleculeB.class) {
            pImage = new PImage(B_IMAGE);
            if (bl) {
                pImage2 = new PImage(B_LABEL_IMAGE);
            }
        } else if (clazz == MoleculeC.class) {
            pImage = new PImage(C_IMAGE);
            if (bl) {
                pImage2 = new PImage(C_LABEL_IMAGE);
            }
        } else {
            throw new InternalError();
        }
        pImage.setOffset(-pImage.getImage().getWidth(null) / 2, -pImage.getImage().getHeight(null) / 2);
        this.addChild(pImage);
        if (pImage2 != null) {
            pImage2.setOffset(-pImage2.getFullBounds().getWidth() / 2.0, -pImage2.getFullBounds().getHeight() / 2.0);
            this.addChild(pImage2);
        }
        if (energyProfile != Profiles.DEFAULT && energyProfile != Profiles.DYO) {
            Color color = MoleculePaints.getDuotoneHue(clazz, energyProfile);
            MakeDuotoneImageOp makeDuotoneImageOp = new MakeDuotoneImageOp(color);
            BufferedImage bufferedImage = makeDuotoneImageOp.filter((BufferedImage)pImage.getImage(), null);
            pImage.setImage(bufferedImage);
        }
    }

    public void update() {
    }

    static {
        try {
            A_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/glass-molecule-A.png");
            B_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/glass-molecule-B.png");
            C_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/glass-molecule-C.png");
            double d = new MoleculeA().getRadius() * 2.0 / (double)A_IMAGE.getWidth();
            A_IMAGE = SimpleMoleculeGraphicNode.scaleImage(A_IMAGE, d);
            double d2 = new MoleculeB().getRadius() * 2.0 / (double)B_IMAGE.getWidth();
            B_IMAGE = SimpleMoleculeGraphicNode.scaleImage(B_IMAGE, d2);
            double d3 = new MoleculeC().getRadius() * 2.0 / (double)C_IMAGE.getWidth();
            C_IMAGE = SimpleMoleculeGraphicNode.scaleImage(C_IMAGE, d3);
            A_LABEL_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/molecule-label-A.png");
            B_LABEL_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/molecule-label-B.png");
            C_LABEL_IMAGE = ImageLoader.loadBufferedImage("reactions-and-rates/images/molecule-label-C.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

