/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.controller.SelectReactionAction;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.view.icons.ReactionSelectorIcons;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class ReactionChooserPanel
extends JPanel
implements MRModel.ModelListener {
    private JRadioButton defaultRB;
    private JRadioButton r1RB;
    private JRadioButton r2RB;
    private JRadioButton r3RB;
    private JRadioButton designYourOwnRB;
    private MRModule module;
    private ActionListener selectionListener;

    public ReactionChooserPanel(MRModule mRModule) {
        super(new GridBagLayout());
        this.module = mRModule;
        mRModule.getMRModel().addListener(this);
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.reactionSelector")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.defaultRB = new JRadioButton();
        this.r1RB = new JRadioButton();
        this.r2RB = new JRadioButton();
        this.r3RB = new JRadioButton();
        this.designYourOwnRB = new JRadioButton();
        buttonGroup.add(this.defaultRB);
        buttonGroup.add(this.r1RB);
        buttonGroup.add(this.r2RB);
        buttonGroup.add(this.r3RB);
        buttonGroup.add(this.designYourOwnRB);
        this.selectionListener = new SelectionHandler();
        this.defaultRB.addActionListener(this.selectionListener);
        this.r1RB.addActionListener(this.selectionListener);
        this.r2RB.addActionListener(this.selectionListener);
        this.r3RB.addActionListener(this.selectionListener);
        this.designYourOwnRB.addActionListener(this.selectionListener);
        JLabel jLabel = new JLabel(ReactionSelectorIcons.getIcon(Profiles.DEFAULT));
        jLabel.addMouseListener(new MoleculeIconMouseAdapter(this.defaultRB));
        JLabel jLabel2 = new JLabel(ReactionSelectorIcons.getIcon(Profiles.R1));
        jLabel2.addMouseListener(new MoleculeIconMouseAdapter(this.r1RB));
        JLabel jLabel3 = new JLabel(ReactionSelectorIcons.getIcon(Profiles.R2));
        jLabel3.addMouseListener(new MoleculeIconMouseAdapter(this.r2RB));
        JLabel jLabel4 = new JLabel(ReactionSelectorIcons.getIcon(Profiles.R3));
        jLabel4.addMouseListener(new MoleculeIconMouseAdapter(this.r3RB));
        JLabel jLabel5 = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.designYourOwn"));
        jLabel5.addMouseListener(new MoleculeIconMouseAdapter(this.designYourOwnRB));
        this.setLayout(new GridBagLayout());
        int n = 13;
        int n2 = 17;
        Insets insets = new Insets(3, 3, 3, 3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, n, 0, insets, 0, 0);
        this.add((Component)this.defaultRB, gridBagConstraints);
        this.add((Component)this.r1RB, gridBagConstraints);
        this.add((Component)this.r2RB, gridBagConstraints);
        this.add((Component)this.r3RB, gridBagConstraints);
        this.add((Component)this.designYourOwnRB, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = n2;
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)jLabel2, gridBagConstraints);
        this.add((Component)jLabel3, gridBagConstraints);
        this.add((Component)jLabel4, gridBagConstraints);
        this.add((Component)jLabel5, gridBagConstraints);
        this.defaultRB.setSelected(true);
    }

    public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
        this.defaultRB.setSelected(energyProfile == Profiles.DEFAULT);
        this.r1RB.setSelected(energyProfile == Profiles.R1);
        this.r2RB.setSelected(energyProfile == Profiles.R2);
        this.r3RB.setSelected(energyProfile == Profiles.R3);
        this.designYourOwnRB.setSelected(energyProfile == Profiles.DYO);
    }

    public void notifyDefaultTemperatureChanged(double d) {
    }

    private class MoleculeIconMouseAdapter
    extends MouseAdapter {
        JToggleButton toggleBtn;

        public MoleculeIconMouseAdapter(JToggleButton jToggleButton) {
            this.toggleBtn = jToggleButton;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.toggleBtn.setSelected(true);
            ReactionChooserPanel.this.selectionListener.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), ""));
        }
    }

    private class SelectionHandler
    implements ActionListener {
        private SelectionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectReactionAction selectReactionAction = new SelectReactionAction(ReactionChooserPanel.this.module);
            String string = "";
            if (ReactionChooserPanel.this.defaultRB.isSelected()) {
                string = SelectReactionAction.DEFAULT_ACTION;
            }
            if (ReactionChooserPanel.this.r1RB.isSelected()) {
                string = SelectReactionAction.R1_ACTION;
            }
            if (ReactionChooserPanel.this.r2RB.isSelected()) {
                string = SelectReactionAction.R2_ACTION;
            }
            if (ReactionChooserPanel.this.r3RB.isSelected()) {
                string = SelectReactionAction.R3_ACTION;
            }
            if (ReactionChooserPanel.this.designYourOwnRB.isSelected()) {
                string = SelectReactionAction.DESIGN_YOUR_OWN_ACTION;
            }
            selectReactionAction.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), string));
        }
    }
}

