/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.controller.SelectReactionAction;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.view.icons.ReactionSelectorIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;

public class ReactionChooserComboBox
extends JComboBox
implements MRModel.ModelListener {
    private AbstractAction selectionAction;
    private JRadioButton defaultRB;
    private JRadioButton r1RB;
    private JRadioButton r2RB;
    private JRadioButton r3RB;
    private JRadioButton designYourOwnRB;
    private ImageIcon defaultItem;
    private ImageIcon r1Item;
    private ImageIcon r2Item;
    private ImageIcon r3Item;
    private String designYourOwnItem;

    public ReactionChooserComboBox(MRModule mRModule) {
        mRModule.getMRModel().addListener(this);
        this.setRenderer(new DefaultListCellRenderer());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.defaultRB = new JRadioButton();
        this.r1RB = new JRadioButton();
        this.r2RB = new JRadioButton();
        this.r3RB = new JRadioButton();
        this.designYourOwnRB = new JRadioButton();
        buttonGroup.add(this.defaultRB);
        buttonGroup.add(this.r1RB);
        buttonGroup.add(this.r2RB);
        buttonGroup.add(this.r3RB);
        buttonGroup.add(this.designYourOwnRB);
        this.selectionAction = new SelectReactionAction(mRModule);
        this.defaultRB.addActionListener(this.selectionAction);
        this.r1RB.addActionListener(this.selectionAction);
        this.r2RB.addActionListener(this.selectionAction);
        this.r3RB.addActionListener(this.selectionAction);
        this.designYourOwnRB.addActionListener(this.selectionAction);
        this.defaultItem = ReactionSelectorIcons.getIcon(Profiles.DEFAULT);
        this.r1Item = ReactionSelectorIcons.getIcon(Profiles.R1);
        this.r2Item = ReactionSelectorIcons.getIcon(Profiles.R2);
        this.r3Item = ReactionSelectorIcons.getIcon(Profiles.R3);
        this.designYourOwnItem = MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.designYourOwn");
        this.addItem(this.defaultItem);
        this.addItem(this.r1Item);
        this.addItem(this.r2Item);
        this.addItem(this.r3Item);
        this.addItem(this.designYourOwnItem);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ReactionChooserComboBox.this.getSelectedItem();
                String string = "";
                if (object == ReactionChooserComboBox.this.defaultItem) {
                    string = SelectReactionAction.DEFAULT_ACTION;
                } else if (object == ReactionChooserComboBox.this.r1Item) {
                    string = SelectReactionAction.R1_ACTION;
                } else if (object == ReactionChooserComboBox.this.r2Item) {
                    string = SelectReactionAction.R2_ACTION;
                } else if (object == ReactionChooserComboBox.this.r3Item) {
                    string = SelectReactionAction.R3_ACTION;
                } else if (object == ReactionChooserComboBox.this.designYourOwnItem) {
                    string = SelectReactionAction.DESIGN_YOUR_OWN_ACTION;
                }
                ReactionChooserComboBox.this.selectionAction.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), string));
            }
        });
        this.defaultRB.setSelected(true);
    }

    public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
        Object object = null;
        object = energyProfile == Profiles.DEFAULT ? this.defaultItem : object;
        object = energyProfile == Profiles.R1 ? this.r1Item : object;
        object = energyProfile == Profiles.R2 ? this.r2Item : object;
        object = energyProfile == Profiles.R3 ? this.r3Item : object;
        object = energyProfile == Profiles.DYO ? this.designYourOwnItem : object;
        this.setSelectedItem(object);
    }

    public void notifyDefaultTemperatureChanged(double d) {
    }
}

