/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.ConstantTemperatureMoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeFactory;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class PumpGraphic
extends PNode
implements Resetable {
    private PImage pumpBodyPI;
    private PImage pumpHandlePI;
    private int initHandleYLoc = -15;
    private Point2D pumpBaseLocation;
    private Class currentMoleculeType;
    private MRModel model;
    private MoleculeTypeSelector moleculeTypeSelector;

    public PumpGraphic(MRModule mRModule) {
        this.model = mRModule.getMRModel();
        this.pumpHandlePI = PImageFactory.create("reactions-and-rates/images/pump-handle.gif");
        this.pumpHandlePI.setOffset(48.0, this.initHandleYLoc);
        this.addChild(this.pumpHandlePI);
        this.pumpHandlePI.addInputEventListener(new PumpHandleMouseHandler());
        this.pumpBodyPI = PImageFactory.create("reactions-and-rates/images/pump-body.gif");
        this.addChild(this.pumpBodyPI);
        this.moleculeTypeSelector = new MoleculeTypeSelector();
        PSwing pSwing = new PSwing(this.moleculeTypeSelector);
        pSwing.setOffset(15.0 + this.pumpBodyPI.getWidth() / 2.0 - pSwing.getWidth() / 2.0, 2.0 + this.pumpBodyPI.getHeight());
        this.addChild(pSwing);
        this.pumpBaseLocation = new Point2D.Double(0.0, this.pumpBodyPI.getHeight());
    }

    public Point2D getPumpBaseLocation() {
        return this.pumpBaseLocation;
    }

    public void reset() {
        this.moleculeTypeSelector.reset();
    }

    private class MoleculeTypeSelector
    extends JPanel
    implements Resetable {
        private JRadioButton aRB;
        private JRadioButton cRB;
        private JRadioButton abRB;
        private JRadioButton bcRB;
        private JLabel iconA = new JLabel();
        private JLabel iconBC = new JLabel();
        private JLabel iconAB = new JLabel();
        private JLabel iconC = new JLabel();

        public MoleculeTypeSelector() {
            this.iconA.addMouseListener(new MoleculeIconMouseAdapter(this.aRB));
            this.iconBC.addMouseListener(new MoleculeIconMouseAdapter(this.bcRB));
            this.iconAB.addMouseListener(new MoleculeIconMouseAdapter(this.abRB));
            this.iconC.addMouseListener(new MoleculeIconMouseAdapter(this.cRB));
            PumpGraphic.this.model.addListener(new MRModel.ModelListenerAdapter(){

                public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                    MoleculeTypeSelector.this.updateIcons();
                }
            });
            this.updateIcons();
            this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.moleculeType")));
            this.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.aRB = new JRadioButton();
            this.cRB = new JRadioButton();
            this.abRB = new JRadioButton();
            this.bcRB = new JRadioButton();
            buttonGroup.add(this.aRB);
            buttonGroup.add(this.cRB);
            buttonGroup.add(this.abRB);
            buttonGroup.add(this.bcRB);
            this.aRB.addActionListener(new MoleculeSelectorRBAction());
            this.cRB.addActionListener(new MoleculeSelectorRBAction());
            this.abRB.addActionListener(new MoleculeSelectorRBAction());
            this.bcRB.addActionListener(new MoleculeSelectorRBAction());
            this.aRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
            this.cRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
            this.abRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
            this.bcRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
            this.setLayout(new GridBagLayout());
            int n = 10;
            int n2 = 10;
            Insets insets = new Insets(3, 3, 3, 3);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, n, 2, insets, 0, 0);
            this.add((Component)this.aRB, gridBagConstraints);
            this.add((Component)this.bcRB, gridBagConstraints);
            this.add((Component)this.abRB, gridBagConstraints);
            this.add((Component)this.cRB, gridBagConstraints);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = n2;
            this.add((Component)this.iconA, gridBagConstraints);
            this.add((Component)this.iconBC, gridBagConstraints);
            this.add((Component)this.iconAB, gridBagConstraints);
            this.add((Component)this.iconC, gridBagConstraints);
            this.aRB.setSelected(true);
            PumpGraphic.this.currentMoleculeType = MoleculeA.class;
        }

        private void updateIcons() {
            this.iconA.setIcon(new MoleculeIcon(MoleculeA.class, PumpGraphic.this.model.getEnergyProfile()));
            this.iconA.setHorizontalAlignment(0);
            this.iconBC.setIcon(new MoleculeIcon(MoleculeBC.class, PumpGraphic.this.model.getEnergyProfile()));
            this.iconBC.setHorizontalAlignment(0);
            this.iconAB.setIcon(new MoleculeIcon(MoleculeAB.class, PumpGraphic.this.model.getEnergyProfile()));
            this.iconAB.setHorizontalAlignment(0);
            this.iconC.setIcon(new MoleculeIcon(MoleculeC.class, PumpGraphic.this.model.getEnergyProfile()));
            this.iconC.setHorizontalAlignment(0);
        }

        private void setMoleculeType() {
            if (this.aRB.isSelected()) {
                PumpGraphic.this.currentMoleculeType = MoleculeA.class;
            }
            if (this.cRB.isSelected()) {
                PumpGraphic.this.currentMoleculeType = MoleculeC.class;
            }
            if (this.abRB.isSelected()) {
                PumpGraphic.this.currentMoleculeType = MoleculeAB.class;
            }
            if (this.bcRB.isSelected()) {
                PumpGraphic.this.currentMoleculeType = MoleculeBC.class;
            }
        }

        public void reset() {
            this.aRB.setSelected(true);
            PumpGraphic.this.currentMoleculeType = MoleculeA.class;
        }

        private class MoleculeIconMouseAdapter
        extends MouseAdapter {
            JToggleButton toggleBtn;

            public MoleculeIconMouseAdapter(JToggleButton jToggleButton) {
                this.toggleBtn = jToggleButton;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.toggleBtn.setSelected(true);
                MoleculeTypeSelector.this.setMoleculeType();
            }
        }

        private class MoleculeSelectorRBAction
        extends AbstractAction {
            private MoleculeSelectorRBAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MoleculeTypeSelector.this.setMoleculeType();
            }
        }
    }

    private class PumpHandleMouseHandler
    extends PBasicInputEventHandler {
        double yStart;
        double dySinceLastMolecule;

        private PumpHandleMouseHandler() {
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            PhetUtilities.getActiveModule().getSimulationPanel().setCursor(Cursor.getPredefinedCursor(8));
        }

        public void mouseExited(PInputEvent pInputEvent) {
            PhetUtilities.getActiveModule().getSimulationPanel().setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mousePressed(PInputEvent pInputEvent) {
            this.yStart = pInputEvent.getPosition().getY();
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            double d = pInputEvent.getDelta().getHeight();
            double d2 = PumpGraphic.this.pumpHandlePI.getOffset().getY() + d;
            if (d2 <= (double)PumpGraphic.this.initHandleYLoc && d2 > -PumpGraphic.this.getOffset().getY()) {
                PumpGraphic.this.pumpHandlePI.setOffset(PumpGraphic.this.pumpHandlePI.getOffset().getX(), d2);
                if (d > 0.0) {
                    if (this.dySinceLastMolecule > 20.0) {
                        AbstractMolecule abstractMolecule = this.createMolecule();
                        PumpGraphic.this.model.addModelElement(abstractMolecule);
                        if (abstractMolecule instanceof CompositeMolecule) {
                            CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule;
                            SimpleMolecule[] simpleMoleculeArray = compositeMolecule.getComponentMolecules();
                            for (int i = 0; i < simpleMoleculeArray.length; ++i) {
                                PumpGraphic.this.model.addModelElement(simpleMoleculeArray[i]);
                            }
                        }
                        this.dySinceLastMolecule = 0.0;
                    } else {
                        this.dySinceLastMolecule += d;
                    }
                }
            }
        }

        private AbstractMolecule createMolecule() {
            double d = PumpGraphic.this.model.getBox().getMaxX() - 20.0;
            double d2 = PumpGraphic.this.model.getBox().getMaxY() - 80.0;
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, 1.0, 1.0);
            ConstantTemperatureMoleculeParamGenerator constantTemperatureMoleculeParamGenerator = new ConstantTemperatureMoleculeParamGenerator(double_, PumpGraphic.this.model, 0.1, 2.356194490192345, 3.9269908169872414, PumpGraphic.this.currentMoleculeType);
            return MoleculeFactory.createMolecule(PumpGraphic.this.currentMoleculeType, constantTemperatureMoleculeParamGenerator);
        }
    }
}

