/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.view.util.ColorFilter;
import edu.colorado.phet.common.phetcommon.view.util.MakeDuotoneImageOp;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.reactions.Profiles;
import edu.colorado.phet.reactionsandrates.view.factories.TextureImageFactory;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;

public class MoleculePaints {
    private static Color moleculeAPaint = new Color(220, 220, 80);
    private static Color moleculeBPaint = new Color(200, 120, 110);
    private static Color moleculeCPaint = new Color(70, 80, 180);
    private static Map cpToPaint = new HashMap();
    private static Map cpToColor = new HashMap();

    public static Paint getPaint(Class clazz, EnergyProfile energyProfile) {
        MultiKey multiKey = MoleculePaints.key(clazz, energyProfile);
        Paint paint = (Paint)cpToPaint.get(multiKey);
        if (paint != null) {
            return paint;
        }
        ColorFilter colorFilter = ColorFilter.NULL;
        ColorFilter colorFilter2 = ColorFilter.NULL;
        ColorFilter colorFilter3 = ColorFilter.NULL;
        if (energyProfile != Profiles.DEFAULT) {
            colorFilter = new MakeDuotoneImageOp(MoleculePaints.getDuotoneHue(MoleculeA.class, energyProfile));
            colorFilter2 = new MakeDuotoneImageOp(MoleculePaints.getDuotoneHue(MoleculeB.class, energyProfile));
            colorFilter3 = new MakeDuotoneImageOp(MoleculePaints.getDuotoneHue(MoleculeC.class, energyProfile));
        }
        Color color = colorFilter.filter(moleculeAPaint);
        Color color2 = colorFilter2.filter(moleculeBPaint);
        Color color3 = colorFilter3.filter(moleculeCPaint);
        if (clazz == MoleculeA.class) {
            return color;
        }
        if (clazz == MoleculeB.class) {
            paint = color2;
        } else if (clazz == MoleculeC.class) {
            paint = color3;
        } else if (clazz == MoleculeAB.class) {
            paint = TextureImageFactory.createTexturePaint(color, color2, 3.0);
        } else if (clazz == MoleculeBC.class) {
            paint = TextureImageFactory.createTexturePaint(color2, color3, 3.0);
        } else {
            assert (false) : "A new molecule class type was added; how to generate the paint for said type is not known.";
            paint = Color.BLACK;
        }
        cpToPaint.put(MoleculePaints.key(clazz, energyProfile), paint);
        return paint;
    }

    public static Color getDuotoneHue(Class clazz, EnergyProfile energyProfile) {
        Color color = (Color)cpToColor.get(new MultiKey(clazz, energyProfile));
        if (color == null) {
            throw new InternalError("A duotone hue for the molecule " + clazz.getName() + " and the profile " + energyProfile + " was not found.");
        }
        return color;
    }

    private static MultiKey key(Class clazz, EnergyProfile energyProfile) {
        return new MultiKey(clazz, energyProfile);
    }

    static {
        cpToColor.put(MoleculePaints.key(MoleculeA.class, Profiles.R1), new Color(0, 150, 0));
        cpToColor.put(MoleculePaints.key(MoleculeB.class, Profiles.R1), new Color(150, 0, 0));
        cpToColor.put(MoleculePaints.key(MoleculeC.class, Profiles.R1), new Color(0, 0, 250));
        cpToColor.put(MoleculePaints.key(MoleculeA.class, Profiles.R2), new Color(0, 100, 250));
        cpToColor.put(MoleculePaints.key(MoleculeB.class, Profiles.R2), new Color(250, 0, 250));
        cpToColor.put(MoleculePaints.key(MoleculeC.class, Profiles.R2), new Color(150, 150, 0));
        cpToColor.put(MoleculePaints.key(MoleculeA.class, Profiles.R3), new Color(200, 60, 0));
        cpToColor.put(MoleculePaints.key(MoleculeB.class, Profiles.R3), new Color(0, 150, 0));
        cpToColor.put(MoleculePaints.key(MoleculeC.class, Profiles.R3), new Color(60, 0, 250));
        cpToColor.put(MoleculePaints.key(MoleculeA.class, Profiles.DYO), new Color(120, 30, 0));
        cpToColor.put(MoleculePaints.key(MoleculeB.class, Profiles.DYO), new Color(30, 0, 120));
        cpToColor.put(MoleculePaints.key(MoleculeC.class, Profiles.DYO), new Color(0, 120, 30));
    }
}

