/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.reactionsandrates.model.Launcher;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LauncherGraphic
extends PNode
implements SimpleObserver {
    private double minTheta = -1.0471975511965976;
    private double maxTheta = 1.0471975511965976;
    private Launcher launcher;
    private PNode plungerNode;
    private PNode plungerFrameNode;
    private PNode plunger2DFrameNode;
    private PNode plunger2DFrameStrutsNode;
    private String baseImagePath = "reactions-and-rates/images/";
    private String plungerImageFile = this.baseImagePath + "plunger.png";
    private String frameImageFile = this.baseImagePath + "frame.png";
    private String frame2DImageFile = this.baseImagePath + "2D-frame.png";
    private String strutsImageFile = this.baseImagePath + "struts.png";
    private Point2D pivotPt;
    private double scale;
    private volatile boolean temperatureBeingAdjusted = false;

    public LauncherGraphic(Launcher launcher) {
        this.launcher = launcher;
        this.plungerNode = PImageFactory.create(this.plungerImageFile);
        this.scale = 100.0 / this.plungerNode.getFullBounds().getHeight();
        this.plungerNode.scale(this.scale);
        this.plungerFrameNode = PImageFactory.create(this.frameImageFile);
        this.plungerFrameNode.scale(this.scale);
        this.plungerFrameNode.setPickable(false);
        this.plungerFrameNode.setChildrenPickable(false);
        this.plunger2DFrameStrutsNode = PImageFactory.create(this.strutsImageFile);
        this.plunger2DFrameStrutsNode.scale(this.scale);
        this.plunger2DFrameNode = PImageFactory.create(this.frame2DImageFile);
        this.plunger2DFrameNode.scale(this.scale);
        this.addChild(this.plunger2DFrameStrutsNode);
        this.addChild(this.plungerNode);
        this.addChild(this.plunger2DFrameNode);
        this.addChild(this.plungerFrameNode);
        this.plunger2DFrameNode.setVisible(false);
        this.plunger2DFrameStrutsNode.setVisible(false);
        double d = this.getFullBounds().getWidth() / 2.0;
        this.plungerNode.setOffset(d - this.plungerNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.plungerFrameNode.setOffset(d - this.plungerFrameNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.plunger2DFrameNode.setOffset(d - this.plunger2DFrameNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.plunger2DFrameStrutsNode.setOffset(d - this.plunger2DFrameStrutsNode.getFullBounds().getWidth() / 2.0, 0.0);
        this.pivotPt = new Point2D.Double(d, 0.0);
        this.setOffset(launcher.getRestingTipLocation().getX() - this.getFullBounds().getWidth() / 2.0, launcher.getRestingTipLocation().getY());
        this.plungerNode.addInputEventListener(new PlungerMouseHandler());
        launcher.addObserver(this);
        this.update();
    }

    public void update() {
        double d = this.launcher.getExtension() / this.scale;
        this.updateTransform(this.plungerNode, d, this.launcher.getTheta());
        this.updateTransform(this.plungerFrameNode, 0.0, this.launcher.getTheta());
        boolean bl = this.launcher.getMovementType() == Launcher.TWO_DIMENSIONAL;
        this.plunger2DFrameStrutsNode.setVisible(bl);
        this.plunger2DFrameNode.setVisible(bl);
    }

    private void updateTransform(PNode pNode, double d, double d2) {
        pNode.setTransform(new AffineTransform());
        pNode.translate(this.pivotPt.getX() - pNode.getFullBounds().getWidth() / 2.0 * this.scale, this.pivotPt.getY());
        pNode.rotateAboutPoint(d2, pNode.getFullBounds().getWidth() / 2.0 * this.scale, 0.0);
        pNode.setScale(this.scale);
        pNode.translate(0.0, d);
    }

    public boolean isTemperatureBeingAdjusted() {
        return this.temperatureBeingAdjusted;
    }

    private class PlungerMouseHandler
    extends PBasicInputEventHandler {
        boolean mousePressed;
        boolean mouseInside;
        double originalAngle;
        double originalR;
        Point2D startPoint;

        private PlungerMouseHandler() {
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            this.mouseInside = true;
            this.updateCursor();
        }

        public void mouseExited(PInputEvent pInputEvent) {
            this.mouseInside = false;
            this.updateCursor();
        }

        public void mousePressed(PInputEvent pInputEvent) {
            this.mousePressed = true;
            if (LauncherGraphic.this.launcher.isEnabled()) {
                LauncherGraphic.this.temperatureBeingAdjusted = true;
                this.originalAngle = LauncherGraphic.this.launcher.getTheta();
                this.originalR = LauncherGraphic.this.launcher.getExtension();
                this.startPoint = pInputEvent.getPositionRelativeTo(LauncherGraphic.this.getParent());
            }
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            if (LauncherGraphic.this.launcher.isEnabled()) {
                double d = 0.0;
                Point2D point2D = pInputEvent.getPositionRelativeTo(LauncherGraphic.this.getParent());
                if (point2D.getY() > LauncherGraphic.this.launcher.getRestingTipLocation().getY()) {
                    double d2;
                    MutableVector2D mutableVector2D = new MutableVector2D(LauncherGraphic.this.launcher.getRestingTipLocation(), this.startPoint);
                    MutableVector2D mutableVector2D2 = new MutableVector2D(LauncherGraphic.this.launcher.getRestingTipLocation(), point2D);
                    if (LauncherGraphic.this.launcher.getMovementType() == Launcher.TWO_DIMENSIONAL) {
                        d2 = mutableVector2D2.getAngle() - mutableVector2D.getAngle();
                        LauncherGraphic.this.launcher.setTheta(this.originalAngle + d2);
                    }
                    d2 = mutableVector2D2.magnitude() - mutableVector2D.magnitude();
                    d = Math.min(70.0, this.originalR + d2);
                }
                LauncherGraphic.this.launcher.setExtension(d);
            }
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            if (LauncherGraphic.this.launcher.isEnabled()) {
                LauncherGraphic.this.temperatureBeingAdjusted = false;
                LauncherGraphic.this.launcher.release();
            }
            this.mousePressed = false;
            this.updateCursor();
        }

        private void updateCursor() {
            if (this.mouseInside && LauncherGraphic.this.launcher.isEnabled()) {
                if (LauncherGraphic.this.launcher.getMovementType() == Launcher.TWO_DIMENSIONAL) {
                    this.setCursor(12);
                } else if (LauncherGraphic.this.launcher.getMovementType() == Launcher.ONE_DIMENSIONAL) {
                    this.setCursor(8);
                }
            } else if (!this.mouseInside && !this.mousePressed) {
                this.setCursor(0);
            }
        }

        private void setCursor(int n) {
            PhetUtilities.getActiveModule().getSimulationPanel().setCursor(Cursor.getPredefinedCursor(n));
        }
    }
}

