/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.view.InitialTemperatureSlider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InitialTemperaturePanel
extends JPanel {
    private final InitialTemperatureSlider slider = new InitialTemperatureSlider();
    private volatile boolean adjustmentInProgress;

    public InitialTemperaturePanel(final MRModule mRModule) {
        super(new GridBagLayout());
        JLabel jLabel = new JLabel(MRConfig.RESOURCES.getLocalizedString("temperature.initial"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.slider, gridBagConstraints);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    InitialTemperaturePanel.this.adjustmentInProgress = true;
                } else {
                    InitialTemperaturePanel.this.adjustmentInProgress = false;
                }
                double d = jSlider.getValue();
                mRModule.clearExperiment();
                mRModule.getMRModel().setDefaultTemperature(d);
            }
        });
    }

    public boolean isTemperatureBeingAdjusted() {
        return this.adjustmentInProgress;
    }

    public void reset() {
        this.slider.reset();
    }
}

