/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.ConstantTemperatureMoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeCounter;
import edu.colorado.phet.reactionsandrates.model.MoleculeFactory;
import edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.modules.RateExperimentsModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.InitialTemperaturePanel;
import edu.colorado.phet.reactionsandrates.view.IntegerRangeSpinner;
import edu.colorado.phet.reactionsandrates.view.ReactionChooserComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ExperimentSetupPanel
extends JPanel
implements Resetable {
    private IntegerRangeSpinner spinnerA;
    private IntegerRangeSpinner spinnerBC;
    private IntegerRangeSpinner spinnerAB;
    private IntegerRangeSpinner spinnerC;
    private HashMap moleculeTypeToGenerator = new HashMap();
    private RateExperimentsModule module;
    private InitialTemperaturePanel initialTemperaturePanel;
    private JButton goButton;

    public ExperimentSetupPanel(final RateExperimentsModule rateExperimentsModule) {
        super(new GridBagLayout());
        this.module = rateExperimentsModule;
        new MoleculeCounter(MoleculeA.class, rateExperimentsModule.getMRModel());
        new MoleculeCounter(MoleculeBC.class, rateExperimentsModule.getMRModel());
        new MoleculeCounter(MoleculeAB.class, rateExperimentsModule.getMRModel());
        new MoleculeCounter(MoleculeC.class, rateExperimentsModule.getMRModel());
        Rectangle2D rectangle2D = rateExperimentsModule.getMRModel().getBox().getBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX() + 20.0, rectangle2D.getMinY() + 20.0, rectangle2D.getWidth() - 40.0, rectangle2D.getHeight() - 40.0);
        ConstantTemperatureMoleculeParamGenerator constantTemperatureMoleculeParamGenerator = new ConstantTemperatureMoleculeParamGenerator(double_, rateExperimentsModule.getMRModel(), 0.1, 0.0, Math.PI * 2, MoleculeA.class);
        ConstantTemperatureMoleculeParamGenerator constantTemperatureMoleculeParamGenerator2 = new ConstantTemperatureMoleculeParamGenerator(double_, rateExperimentsModule.getMRModel(), 0.1, 0.0, Math.PI * 2, MoleculeBC.class);
        ConstantTemperatureMoleculeParamGenerator constantTemperatureMoleculeParamGenerator3 = new ConstantTemperatureMoleculeParamGenerator(double_, rateExperimentsModule.getMRModel(), 0.1, 0.0, Math.PI * 2, MoleculeAB.class);
        ConstantTemperatureMoleculeParamGenerator constantTemperatureMoleculeParamGenerator4 = new ConstantTemperatureMoleculeParamGenerator(double_, rateExperimentsModule.getMRModel(), 0.1, 0.0, Math.PI * 2, MoleculeC.class);
        this.moleculeTypeToGenerator.put(MoleculeA.class, constantTemperatureMoleculeParamGenerator);
        this.moleculeTypeToGenerator.put(MoleculeBC.class, constantTemperatureMoleculeParamGenerator2);
        this.moleculeTypeToGenerator.put(MoleculeAB.class, constantTemperatureMoleculeParamGenerator3);
        this.moleculeTypeToGenerator.put(MoleculeC.class, constantTemperatureMoleculeParamGenerator4);
        JLabel jLabel = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.topLine"));
        JLabel jLabel2 = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.numA"));
        JLabel jLabel3 = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.numBC"));
        JLabel jLabel4 = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.numAB"));
        JLabel jLabel5 = new JLabel(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.numC"));
        this.spinnerA = new IntegerRangeSpinner(0, 100);
        this.spinnerBC = new IntegerRangeSpinner(0, 100);
        this.spinnerAB = new IntegerRangeSpinner(0, 100);
        this.spinnerC = new IntegerRangeSpinner(0, 100);
        this.goButton = new JButton(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.go"));
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (rateExperimentsModule.isExperimentRunning()) {
                    ExperimentSetupPanel.this.endExperiment();
                } else {
                    ExperimentSetupPanel.this.beginExperiment();
                }
            }
        });
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 3, 3, 3), 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 3, 3, 3), 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MRConfig.RESOURCES.getLocalizedString("Control.selectReaction")), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        this.add((Component)new ReactionChooserComboBox(rateExperimentsModule), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel2, gridBagConstraints);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = -1;
        this.add((Component)jLabel3, gridBagConstraints);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints2.gridy = -1;
        this.add((Component)this.spinnerA, gridBagConstraints2);
        this.add((Component)this.spinnerAB, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = -1;
        this.add((Component)this.spinnerBC, gridBagConstraints2);
        this.add((Component)this.spinnerC, gridBagConstraints2);
        this.initialTemperaturePanel = new InitialTemperaturePanel(rateExperimentsModule);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.initialTemperaturePanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        jPanel.add(this.goButton);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private void generateMolecules(Class clazz, int n) {
        MRModel mRModel = this.module.getMRModel();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                MoleculeParamGenerator moleculeParamGenerator = (MoleculeParamGenerator)this.moleculeTypeToGenerator.get(clazz);
                AbstractMolecule abstractMolecule = MoleculeFactory.createMolecule(clazz, moleculeParamGenerator);
                if (abstractMolecule instanceof CompositeMolecule) {
                    CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule;
                    for (int j = 0; j < compositeMolecule.getComponentMolecules().length; ++j) {
                        mRModel.addModelElement(compositeMolecule.getComponentMolecules()[j]);
                    }
                }
                mRModel.addModelElement(abstractMolecule);
            }
        } else {
            for (int i = n; i < 0; ++i) {
                ArrayList arrayList = mRModel.getModelElements();
                boolean bl = false;
                for (int j = 0; j < arrayList.size() && !bl; ++j) {
                    Object e = arrayList.get(j);
                    if (!clazz.isInstance(e)) continue;
                    if (e instanceof CompositeMolecule) {
                        CompositeMolecule compositeMolecule = (CompositeMolecule)e;
                        for (int k = 0; k < compositeMolecule.getComponentMolecules().length; ++k) {
                            mRModel.removeModelElement(compositeMolecule.getComponentMolecules()[k]);
                        }
                    }
                    mRModel.removeModelElement((ModelElement)e);
                }
            }
        }
    }

    private void setInitialMoleculeCountsEnabled(boolean bl) {
        this.spinnerA.setEnabled(bl);
        this.spinnerBC.setEnabled(bl);
        this.spinnerAB.setEnabled(bl);
        this.spinnerC.setEnabled(bl);
    }

    public void reset() {
        this.endExperiment();
        this.spinnerA.setIntValue(0);
        this.spinnerBC.setIntValue(0);
        this.spinnerAB.setIntValue(0);
        this.spinnerC.setIntValue(0);
        if (this.module.isActive()) {
            this.module.getClock().start();
        }
        this.module.resetStripChart();
        this.initialTemperaturePanel.reset();
    }

    public void endExperiment() {
        this.goButton.setText(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.go"));
        this.setInitialMoleculeCountsEnabled(true);
        this.module.getClock().pause();
        this.module.setExperimentRunning(false);
    }

    private void beginExperiment() {
        this.goButton.setText(MRConfig.RESOURCES.getLocalizedString("ExperimentSetup.stop"));
        this.goButton.setEnabled(false);
        this.setInitialMoleculeCountsEnabled(false);
        this.module.getMRModel().removeAllMolecules();
        this.module.resetStripChart();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExperimentSetupPanel.this.generateMolecules(MoleculeA.class, ExperimentSetupPanel.this.spinnerA.getIntValue());
                ExperimentSetupPanel.this.generateMolecules(MoleculeBC.class, ExperimentSetupPanel.this.spinnerBC.getIntValue());
                ExperimentSetupPanel.this.generateMolecules(MoleculeAB.class, ExperimentSetupPanel.this.spinnerAB.getIntValue());
                ExperimentSetupPanel.this.generateMolecules(MoleculeC.class, ExperimentSetupPanel.this.spinnerC.getIntValue());
                ExperimentSetupPanel.this.module.setExperimentRunning(true);
                ExperimentSetupPanel.this.module.getClock().start();
                ExperimentSetupPanel.this.goButton.setEnabled(true);
            }
        };
        Timer timer = new Timer(1000, actionListener);
        timer.setRepeats(false);
        timer.start();
    }

    public boolean isTemperatureBeingAdjusted() {
        return this.initialTemperaturePanel.isTemperatureBeingAdjusted();
    }
}

