/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.reactionsandrates.DebugFlags;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Ellipse2D;

public class CompositeMoleculeGraphic
extends PNode
implements SimpleObserver {
    private CompositeMolecule compositeMolecule;
    private PPath cmNode;
    private PPath boundingBox;

    public Object clone() {
        return new CompositeMoleculeGraphic((CompositeMolecule)this.compositeMolecule.clone());
    }

    public CompositeMoleculeGraphic(CompositeMolecule compositeMolecule) {
        this.compositeMolecule = compositeMolecule;
        if (DebugFlags.SHOW_BOUNDING_BOX) {
            this.boundingBox = new PPath(compositeMolecule.getBoundingBox());
            this.addChild(this.boundingBox);
        }
        if (DebugFlags.SHOW_CM) {
            double d = 2.0;
            this.cmNode = new PPath(new Ellipse2D.Double(-d, -d, d * 2.0, d * 2.0));
            this.cmNode.setPaint(Color.red);
            this.addChild(this.cmNode);
            this.update();
        }
        compositeMolecule.addObserver(this);
    }

    public void update() {
        if (DebugFlags.SHOW_BOUNDING_BOX) {
            this.boundingBox.setPathTo(this.compositeMolecule.getBoundingBox());
        }
        if (DebugFlags.SHOW_CM) {
            if (this.cmNode == null || this.compositeMolecule == null) {
                System.out.println("CompositeMoleculeGraphic.update");
            }
            this.cmNode.setOffset(this.compositeMolecule.getCM());
        }
    }
}

