/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.reactionsandrates.model.Bond;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class BondGraphic
extends PPath
implements SimpleObserver {
    private Stroke bondStroke = new BasicStroke(3.0f);
    private Paint bondPaint = new Color(255, 0, 0, 180);
    private Line2D bondLine = new Line2D.Double();
    private Bond bond;

    public BondGraphic(Bond bond) {
        this.bond = bond;
        SimpleMolecule simpleMolecule = bond.getParticipants()[0];
        SimpleMolecule simpleMolecule2 = bond.getParticipants()[1];
        this.setStrokePaint(this.bondPaint);
        this.setStroke(this.bondStroke);
        bond.addObserver(this);
        this.setPickable(false);
        this.update();
    }

    public void update() {
        SimpleMolecule simpleMolecule = this.bond.getParticipants()[0];
        SimpleMolecule simpleMolecule2 = this.bond.getParticipants()[1];
        this.bondLine.setLine(simpleMolecule.getPosition().getX(), simpleMolecule.getPosition().getY(), simpleMolecule2.getPosition().getX(), simpleMolecule2.getPosition().getY());
        this.setPathTo(this.bondLine);
    }
}

