/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AxisNode
extends PNode {
    public static final VerticalAlignment TOP = new VerticalAlignment();
    public static final VerticalAlignment BOTTOM = new VerticalAlignment();
    public static final Orientation HORIZONTAL = new Orientation();
    public static final Orientation VERTICAL = new Orientation();
    public Font axisFont;

    public AxisNode(String string, double d, Color color, Orientation orientation, VerticalAlignment verticalAlignment) {
        double d2 = orientation == HORIZONTAL ? this.addLineNode(d, color) : this.addArrowNode(d, color, verticalAlignment);
        this.axisFont = new PhetFont(PhetFont.getDefaultFontSize() + 1, true);
        PText pText = new PText(string);
        pText.setFont(this.axisFont);
        pText.setTextPaint(color);
        double d3 = 0.0;
        if (verticalAlignment == BOTTOM) {
            d3 = 5.0;
        }
        if (verticalAlignment == TOP) {
            d3 = -5.0 - pText.getHeight();
        }
        pText.setOffset((d2 - pText.getFullBounds().getWidth()) / 2.0, d3);
        this.addChild(pText);
        if (orientation == VERTICAL) {
            this.rotate(-1.5707963267948966);
        }
    }

    private double addArrowNode(double d, Color color, VerticalAlignment verticalAlignment) {
        Arrow arrow = new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(d, 0.0), 12.0, 8.0, 1.0);
        PPath pPath = this.addAxisNode(arrow.getShape(), color);
        return pPath.getFullBounds().getWidth();
    }

    private double addLineNode(double d, Color color) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, d, 1.0);
        return this.addAxisNode(double_, color).getFullBounds().getWidth();
    }

    private PPath addAxisNode(Shape shape, Color color) {
        PPath pPath = new PPath(shape);
        pPath.setPaint(color);
        pPath.setStroke(new BasicStroke(1.0f));
        pPath.setStrokePaint(color);
        this.addChild(pPath);
        return pPath;
    }

    public static class Orientation {
        private Orientation() {
        }
    }

    public static class VerticalAlignment {
        private VerticalAlignment() {
        }
    }
}

