/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.Launcher;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeFactory;
import edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.Selectable;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.TemperatureControl;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.modules.SimpleMRControlPanel;
import edu.colorado.phet.reactionsandrates.util.ModelElementGraphicManager;
import edu.colorado.phet.reactionsandrates.view.LauncherGraphic;
import edu.colorado.phet.reactionsandrates.view.LauncherLoadPanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SimpleModule
extends MRModule {
    private Launcher launcher;
    private SimpleMRControlPanel controlPanel;
    private Point2D launcherTipLocation;
    private CompositeMolecule cm;
    private SimpleMolecule launcherMolecule;
    private Class launcherMoleculeClass = MRConfig.DEFAULT_LAUNCHER_MOLECULE_CLASS;
    private LauncherLoadPanel launcherLoadPanel;
    private LauncherGraphic launcherGraphic;

    public SimpleModule() {
        super(MRConfig.RESOURCES.getLocalizedString("module.single-collision"), MRConfig.MOLECULE_SEPARATION_PANE_SIZE);
        MRModel mRModel = this.getThisModel();
        this.getSpatialView().addGraphicFactory(new ModelElementGraphicManager.GraphicFactory(Launcher.class, this.getSpatialView().getTopLayer()){

            public PNode createGraphic(ModelElement modelElement) {
                SimpleModule.this.launcherGraphic = new LauncherGraphic((Launcher)modelElement);
                return SimpleModule.this.launcherGraphic;
            }
        });
        this.launcherTipLocation = new Point2D.Double((mRModel.getBox().getMinX() + mRModel.getBox().getMaxX()) / 2.0, mRModel.getBox().getMaxY());
        this.launcherLoadPanel = new LauncherLoadPanel(this);
        PSwing pSwing = new PSwing(this.launcherLoadPanel);
        this.getSpatialView().addChild(pSwing);
        pSwing.setOffset(this.launcherTipLocation.getX() - pSwing.getFullBounds().getWidth() - 70.0, this.launcherTipLocation.getY() + 15.0);
        this.setInitialConditions();
        this.controlPanel = new SimpleMRControlPanel(this);
        this.getControlPanel().addControl(this.controlPanel);
        this.getEnergyView().setProfileManipulable(false);
        this.getEnergyView().setEnergyViewVisible(false);
        this.getEnergyView().setSeparationViewVisible(false);
        this.createWiggleMe();
    }

    public boolean isTemperatureBeingAdjusted() {
        boolean bl = super.isTemperatureBeingAdjusted();
        if (!bl) {
            bl = this.launcherGraphic.isTemperatureBeingAdjusted();
        }
        return bl;
    }

    public void activate() {
        super.activate();
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    protected void setInitialConditions() {
        MRModel mRModel = this.getThisModel();
        TemperatureControl temperatureControl = mRModel.getTemperatureControl();
        temperatureControl.setPosition(mRModel.getBox().getMaxX() - 50.0, temperatureControl.getPosition().getY());
        if (this.launcher == null) {
            this.launcher = new Launcher(this.launcherTipLocation);
        }
        this.launcher.setMovementType(Launcher.ONE_DIMENSIONAL);
        this.launcher.setExtension(0.0);
        mRModel.addModelElement(this.launcher);
        this.launcherMoleculeClass = MoleculeA.class;
        this.resetMolecules();
    }

    public void clearExperiment() {
        super.clearExperiment();
        this.resetMolecules();
    }

    public void resetMolecules() {
        MRModel mRModel = this.getThisModel();
        SimpleMolecule simpleMolecule = null;
        if (this.launcherMoleculeClass == MoleculeC.class) {
            simpleMolecule = new MoleculeC();
        } else if (this.launcherMoleculeClass == MoleculeA.class) {
            simpleMolecule = new MoleculeA();
        }
        SwingUtilities.invokeLater(new MoleculeCreator(mRModel, simpleMolecule));
    }

    public MRModel getThisModel() {
        return (MRModel)super.getModel();
    }

    public void setMolecules(MRModel mRModel, SimpleMolecule simpleMolecule) {
        Object object;
        this.initiateReset();
        mRModel.removeAllMolecules();
        this.launcherMoleculeClass = simpleMolecule.getClass();
        if (this.launcherMolecule != null) {
            simpleMolecule.setSelectionStatus(Selectable.NOT_SELECTED);
            mRModel.removeModelElement(this.launcherMolecule);
        }
        if (this.cm != null) {
            mRModel.removeModelElement(this.cm);
            for (int i = 0; i < this.cm.getComponentMolecules().length; ++i) {
                object = this.cm.getComponentMolecules()[i];
                mRModel.removeModelElement((ModelElement)object);
            }
        }
        this.launcherMolecule = simpleMolecule;
        simpleMolecule.setPosition(this.launcher.getRestingTipLocation().getX(), this.launcher.getRestingTipLocation().getY() - simpleMolecule.getRadius());
        mRModel.addModelElement(simpleMolecule);
        this.launcher.setBodyToLaunch(simpleMolecule);
        this.launcher.setTheta(0.0);
        this.cm = null;
        Class clazz = null;
        object = new MoleculeParamGenerator(simpleMolecule, mRModel);
        clazz = simpleMolecule instanceof MoleculeC ? MoleculeAB.class : MoleculeBC.class;
        this.cm = (CompositeMolecule)MoleculeFactory.createMolecule(clazz, (edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator)object);
        this.cm.rotate(1.5707963267948966);
        this.cm.setOmega(0.0);
        this.cm.setVelocity(0.0, 0.0);
        mRModel.addModelElement(this.cm);
        for (int i = 0; i < this.cm.getComponentMolecules().length; ++i) {
            SimpleMolecule simpleMolecule2 = this.cm.getComponentMolecules()[i];
            mRModel.addModelElement(simpleMolecule2);
        }
        simpleMolecule.setSelectionStatus(Selectable.SELECTED);
        this.getEnergyView().reset();
        this.completeReset();
    }

    public void reset() {
        super.reset();
        this.setInitialConditions();
        this.controlPanel.reset();
    }

    public void reload() {
        Launcher.MovementType movementType = this.launcher.getMovementType();
        this.launcherMoleculeClass = this.launcherMolecule.getClass();
        this.resetMolecules();
        this.launcherLoadPanel.setMolecule(this.launcherMolecule);
        this.launcher.setMovementType(movementType);
        this.getClock().start();
    }

    private void createWiggleMe() {
        final PhetPCanvas phetPCanvas = this.getCanvas();
        final MotionHelpBalloon motionHelpBalloon = new MotionHelpBalloon(phetPCanvas, MRConfig.RESOURCES.getLocalizedString("messages.invitation"));
        motionHelpBalloon.setOffset(0.0, 0.0);
        motionHelpBalloon.setBalloonFillPaint(new Color(255, 255, 100));
        motionHelpBalloon.setBalloonVisible(true);
        motionHelpBalloon.setBalloonStroke(new BasicStroke(1.0f));
        phetPCanvas.addWorldChild(motionHelpBalloon);
        motionHelpBalloon.setVisible(true);
        motionHelpBalloon.animateTo(this.launcher.getRestingTipLocation().getX() - motionHelpBalloon.getFullBounds().getWidth() - 15.0, this.launcher.getRestingTipLocation().getY() + 85.0);
        this.launcherGraphic.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                super.mousePressed(pInputEvent);
                SimpleModule.this.launcherGraphic.removeInputEventListener(this);
                phetPCanvas.removeWorldChild(motionHelpBalloon);
            }
        });
    }

    private class MoleculeCreator
    implements Runnable {
        private final MRModel model;
        private final SimpleMolecule launcherMolecule;

        public MoleculeCreator(MRModel mRModel, SimpleMolecule simpleMolecule) {
            this.model = mRModel;
            this.launcherMolecule = simpleMolecule;
        }

        public void run() {
            SimpleModule.this.setMolecules(this.model, this.launcherMolecule);
            SimpleModule.this.launcherLoadPanel.setMolecule(this.launcherMolecule);
        }
    }

    private static class MoleculeParamGenerator
    implements edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator {
        private final SimpleMolecule launcherMolecule;
        private final MRModel model;

        public MoleculeParamGenerator(SimpleMolecule simpleMolecule, MRModel mRModel) {
            this.launcherMolecule = simpleMolecule;
            this.model = mRModel;
        }

        public MoleculeParamGenerator.Params generate() {
            return new MoleculeParamGenerator.Params(new Point2D.Double(this.launcherMolecule.getPosition().getX(), this.model.getBox().getMinY() + this.model.getBox().getHeight() / 2.0), new MutableVector2D(), 0.0);
        }
    }
}

