/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.Launcher;
import edu.colorado.phet.reactionsandrates.modules.MRControlPanel;
import edu.colorado.phet.reactionsandrates.modules.SimpleModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.util.Resetable;
import edu.colorado.phet.reactionsandrates.view.ReactionChooserPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SimpleMRControlPanel
extends MRControlPanel {
    private LauncherOptionsPanel launcherOptionsPanel;

    public SimpleMRControlPanel(final SimpleModule simpleModule) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0);
        this.launcherOptionsPanel = new LauncherOptionsPanel(simpleModule);
        this.add((Component)this.launcherOptionsPanel, gridBagConstraints);
        this.add((Component)new ReactionChooserPanel(simpleModule), gridBagConstraints);
        gridBagConstraints.fill = 0;
        JButton jButton = new JButton(MRConfig.RESOURCES.getLocalizedString("Control.reload"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                simpleModule.reload();
            }
        });
        gridBagConstraints.anchor = 10;
        this.add((Component)jButton, gridBagConstraints);
        ResetAllButton resetAllButton = new ResetAllButton(this);
        resetAllButton.addResettable(new Resettable(){

            public void reset() {
                simpleModule.reset();
            }
        });
        gridBagConstraints.anchor = 10;
        this.add((Component)resetAllButton, gridBagConstraints);
    }

    public void reset() {
        this.launcherOptionsPanel.reset();
    }

    private class LauncherOptionsPanel
    extends JPanel
    implements Resetable {
        private SimpleModule module;
        private JRadioButton oneDRB;
        private JRadioButton twoDRB;

        public LauncherOptionsPanel(final SimpleModule simpleModule) {
            this.module = simpleModule;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.oneDRB = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.oneDimension"));
            this.twoDRB = new JRadioButton(MRConfig.RESOURCES.getLocalizedString("Control.twoDimensions"));
            buttonGroup.add(this.oneDRB);
            buttonGroup.add(this.twoDRB);
            this.oneDRB.setSelected(true);
            simpleModule.getLauncher().addChangeListener(new Launcher.ChangeListener(){

                public void stateChanged(Launcher launcher) {
                    if (launcher.getMovementType() == Launcher.ONE_DIMENSIONAL && !LauncherOptionsPanel.this.oneDRB.isSelected()) {
                        LauncherOptionsPanel.this.oneDRB.setSelected(true);
                    }
                    if (launcher.getMovementType() == Launcher.TWO_DIMENSIONAL && !LauncherOptionsPanel.this.twoDRB.isSelected()) {
                        LauncherOptionsPanel.this.twoDRB.setSelected(true);
                    }
                }
            });
            this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.launcherOptions")));
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(0, 10, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 0, insets, 0, 0);
            this.add((Component)this.oneDRB, gridBagConstraints);
            this.add((Component)this.twoDRB, gridBagConstraints);
            this.oneDRB.addActionListener(new LauncherRBActionListener());
            this.twoDRB.addActionListener(new LauncherRBActionListener());
            simpleModule.getLauncher().addChangeListener(new Launcher.ChangeListener(){

                public void stateChanged(Launcher launcher) {
                    LauncherOptionsPanel.this.oneDRB.setSelected(simpleModule.getLauncher().getMovementType() == Launcher.ONE_DIMENSIONAL);
                    LauncherOptionsPanel.this.twoDRB.setSelected(simpleModule.getLauncher().getMovementType() == Launcher.TWO_DIMENSIONAL);
                }
            });
        }

        public void reset() {
            this.oneDRB.setSelected(true);
            this.module.getLauncher().setMovementType(Launcher.ONE_DIMENSIONAL);
        }

        private class LauncherRBActionListener
        implements ActionListener {
            private LauncherRBActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Launcher.MovementType movementType = null;
                if (LauncherOptionsPanel.this.oneDRB.isSelected()) {
                    movementType = Launcher.ONE_DIMENSIONAL;
                }
                if (LauncherOptionsPanel.this.twoDRB.isSelected()) {
                    movementType = Launcher.TWO_DIMENSIONAL;
                }
                LauncherOptionsPanel.this.module.resetMolecules();
                LauncherOptionsPanel.this.module.getLauncher().setMovementType(movementType);
            }
        }
    }
}

