/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.clock.StopwatchPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.colorado.phet.reactionsandrates.modules.ComplexMRControlPanel;
import edu.colorado.phet.reactionsandrates.modules.MRControlPanel;
import edu.colorado.phet.reactionsandrates.modules.MRModule;
import edu.colorado.phet.reactionsandrates.view.PumpGraphic;
import edu.colorado.phet.reactionsandrates.view.charts.MoleculePopulationsBarChartNode;
import edu.colorado.phet.reactionsandrates.view.charts.MoleculePopulationsPieChartNode;
import edu.colorado.phet.reactionsandrates.view.charts.StripChartNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.geom.Rectangle2D;

public class ComplexModule
extends MRModule {
    private MRControlPanel controlPanel;
    private PumpGraphic pumpGraphic;
    private MoleculePopulationsBarChartNode barChartNode;
    private MoleculePopulationsPieChartNode pieChart;
    private boolean firstTimeStripChartVisible = true;
    private PSwing stopwatchAdapter;
    private StopwatchPanel stopwatchPanel;
    private final StripChartNode stripChartNode;

    public ComplexModule() {
        this(MRConfig.RESOURCES.getLocalizedString("module.many-collisions"));
    }

    protected ComplexModule(String string) {
        super(string, MRConfig.CHART_PANE_SIZE);
        this.addMovableStopwatch(29.0, 453.0);
        this.getEnergyView().setEnergyLineLabel("EnergyView.Legend.totalAverageEnergy");
        this.stripChartNode = new StripChartNode(this, MRConfig.CHART_PANE_SIZE);
        MRModel mRModel = this.getMRModel();
        mRModel.setAverageTotal(true);
        mRModel.setDefaultTemperature(100.0);
        this.pumpGraphic = new PumpGraphic(this);
        this.pumpGraphic.setOffset(mRModel.getBox().getMinX() + mRModel.getBox().getWidth(), mRModel.getBox().getMinY() + mRModel.getBox().getHeight() + 15.0 - this.pumpGraphic.getPumpBaseLocation().getY());
        this.getSpatialView().addChild(this.pumpGraphic);
        this.controlPanel = this.createControlPanel();
        this.getControlPanel().addControl(this.controlPanel);
        this.getMRModel().addListener(new PublishingModel.ModelListenerAdapter(){

            public void modelElementAdded(ModelElement modelElement) {
                if (modelElement instanceof AbstractMolecule) {
                    ComplexModule.this.setStripChartRecording(true);
                }
            }
        });
        this.getEnergyView().clearUpperPaneContent();
        IClock iClock = this.getClock();
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeReset(ClockEvent clockEvent) {
                ComplexModule.this.resetStripChart();
            }
        });
    }

    public boolean isTemperatureBeingAdjusted() {
        boolean bl = super.isTemperatureBeingAdjusted();
        if (!bl && this.controlPanel != null) {
            bl = this.controlPanel.isTemperatureBeingAdjusted();
        }
        return bl;
    }

    protected MRControlPanel createControlPanel() {
        return new ComplexMRControlPanel(this);
    }

    public void activate() {
        super.activate();
    }

    public void clearExperiment() {
        super.clearExperiment();
        this.pumpGraphic.reset();
    }

    public void reset() {
        super.reset();
        this.setInitialConditions();
        this.controlPanel.reset();
        this.pumpGraphic.reset();
        this.resetStripChart();
        this.stopwatchPanel.stop();
        this.stopwatchPanel.reset();
    }

    private void setInitialConditions() {
        this.setBarChartVisible(false);
        this.setPieChartVisible(false);
    }

    public void setPieChartVisible(boolean bl) {
        if (bl) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getEnergyView().getUpperPaneSize().getWidth(), this.getEnergyView().getUpperPaneSize().getHeight());
            this.pieChart = new MoleculePopulationsPieChartNode(this, double_);
            this.getEnergyView().setUpperPaneContent(this.pieChart);
        } else {
            this.getEnergyView().clearUpperPaneContent(this.pieChart);
        }
    }

    public void setBarChartVisible(boolean bl) {
        if (bl) {
            this.barChartNode = new MoleculePopulationsBarChartNode(this, this.getEnergyView().getUpperPaneSize(), (PhetPCanvas)this.getSimulationPanel());
            this.barChartNode.rescale();
            this.getEnergyView().setUpperPaneContent(this.barChartNode);
        } else {
            this.getEnergyView().clearUpperPaneContent(this.barChartNode);
        }
    }

    public void setStripChartVisible(boolean bl) {
        if (bl) {
            if (this.firstTimeStripChartVisible) {
                this.stripChartNode.rescale();
                this.firstTimeStripChartVisible = false;
            }
            this.getEnergyView().setUpperPaneContent(this.stripChartNode);
        } else {
            this.getEnergyView().clearUpperPaneContent(this.stripChartNode);
        }
    }

    protected void setFirstTimeStripChartVisible(boolean bl) {
        this.firstTimeStripChartVisible = bl;
    }

    public void resetStripChart() {
        this.stripChartNode.reset();
    }

    public void setStripChartRecording(boolean bl) {
        this.stripChartNode.setRecording(bl);
    }

    public void setStopwatchVisible(boolean bl) {
        this.stopwatchAdapter.setVisible(bl);
    }

    protected void addMovableStopwatch(double d, double d2) {
        this.stopwatchPanel = new StopwatchPanel(this.getClock());
        this.stopwatchAdapter = new PSwing(this.stopwatchPanel);
        this.stopwatchAdapter.setOffset(d, d2);
        this.stopwatchAdapter.addInputEventListener(new PDragEventHandler());
        this.getCanvas().addScreenChild(this.stopwatchAdapter);
    }
}

